% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkspotterUI.R
\name{linkspotterUI}
\alias{linkspotterUI}
\title{Linspotter user interface runner}
\usage{
linkspotterUI(dataset, corDF, variablesClustering = NULL,
  defaultMinCor = 0.3, appTitle = "Linkspotter", htmlTop = "",
  htmlBottom = "", ...)
}
\arguments{
\item{dataset}{the dataframe which variables bivariate correlations are contained in corDF}

\item{corDF}{a specific dataframe containing correlations values resulting from the function multiBivariateCorrelation()}

\item{variablesClustering}{a specific dataframe containing the output of the variable clustering resulting from the function clusterVariables()}

\item{defaultMinCor}{a double between 0 and 1. It is the minimal correlation absolute value to consider for the first graph plot.}

\item{appTitle}{a character string taken as the title of the user interface.}

\item{htmlTop}{a character string that enable to customize your shiny app by adding an HTML code in the HEAD tag.}

\item{htmlBottom}{a character string that enable to customize your shiny app by adding an HTML code at the end of the BODY tag.}

\item{...}{: arguments for 'shiny::shinyApp' function}
}
\value{
a 'shiny.appobj' object enable to deploy instantly the user interface for a customizable visualization.
}
\description{
Run the linkSpotter user interface
}
\examples{
# calculate a correlation dataframe
data(iris)
corDF=multiBivariateCorrelation(dataset = iris)
corMatrix=corCouplesToMatrix(x1_x2_val = corDF[,c('X1','X2',"MaxNMI")])
corGroups=clusterVariables(corMatrix = corMatrix, nbCluster = 3)
\dontrun{
# launch the UI
linkspotterUI(dataset=iris, corDF=corDF, variablesClustering=corGroups,
defaultMinCor=0.3,cappTitle="Linkspotter on iris data",
options = list(port=8000)
)
}

}
