% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidData.R
\name{liquidData}
\alias{liquidData}
\alias{print.liquidData}
\alias{sample.liquidData}
\alias{ttsplit}
\title{Loads or downloads training and testing data}
\usage{
liquidData(name, factor_cols, header = FALSE, loc = c(".", "~/sml/data",
  "~/liquidData", system.file("data", package = "liquidSVM"), "../../../data",
  "http://www.isa.uni-stuttgart.de/liquidData"), prob = NULL,
  testSize = NULL, trainSize = NULL, stratified = NULL)

ttsplit(data, target = NULL, testProb = 0.2, testSize = NULL,
  stratified = NULL)

sample.liquidData(liquidData, prob = 0.2, trainSize = NULL,
  testSize = NULL, stratified = NULL)

\method{print}{liquidData}(x, ...)
}
\arguments{
\item{name}{name of the data set. If not given then a list of available names in \code{loc} is returned}

\item{factor_cols}{list of column numbers that are factors (or list of header names, if \code{header=TRUE})}

\item{header}{do the data files have headers}

\item{loc}{vector of locations where the data should be searched for}

\item{prob}{probability of sample being put into test set}

\item{testSize}{size of the test set. If stratified, this will only be approximately fulfilled.}

\item{trainSize}{size of the train set. If stratified, this will only be approximately fulfilled.}

\item{stratified}{whether sampling should be done separately in every bin defined by
the unique values of the target column.
Also can be index or name of the column in \code{data} that should be used to define bins.}

\item{data}{the given data set}

\item{target}{optional name or index of the target variable.
If both this and \code{stratified} are not specified there will be no stratification.}

\item{testProb}{probability of sample being put into test set}

\item{liquidData}{the given liquidData}

\item{x}{the model to print}

\item{...}{other arguments to print.default}
}
\value{
if name is specified an liquidData object: an environment with $train and $test datasets as well as $name and optionally $target as name of the target variable.
If no name is spacified a character vector of available names in \code{loc}.
}
\description{
This looks at several locations to find a  \code{\var{name}.train.csv} and \code{\var{name}.test.csv}.
If it does then it loads or downloads it, parses it, and returns an \code{liquidData}-object.
The files also can be gzipped having names  \code{\var{name}.train.csv.gz} and  \code{\var{name}.test.csv.gz}.
}
\examples{
banana <- liquidData('banana-mc')

## to get a smaller sample
liquidData('banana-mc',prob=0.2)
## if you disable stratified then there is some variance in the group sizes:
liquidData('banana-mc',prob=0.2, stratified=FALSE)

\dontrun{
## to downlad a file from our web directory

liquidData("gisette")

## To get a list of available names:
liquidData()
}
## to produce an liquidData from some dataset
ttsplit(iris)
# the following will be stratified
ttsplit(iris,'Species')

# specify a testSize:
ttsplit(trees, testSize=10)
## example for sample.liquidData
banana <- liquidData('banana-mc')
sample.liquidData(banana, prob=0.1)
# this is equivalent to
liquidData('banana-mc', prob=0.1)
## example for print
banana <- liquidData("banana-mc")
print(banana)
}
\seealso{
\code{\link{ttsplit}}
}

