% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{lsSVM}
\alias{lsSVM}
\alias{svmRegression}
\title{Least Squares Regression}
\usage{
lsSVM(x, y, ..., clipping = -1, do.select = TRUE)

svmRegression(x, y, ..., clipping = -1, do.select = TRUE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{clipping}{absolute value where the estimated labels will be clipped. -1 (the default)
leads to an adaptive clipping value, whereas 0 disables clipping.}

\item{do.select}{if \code{TRUE} also does the whole selection for this model}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
This routine performs non-parametric least squares regression
using SVMs. The tested estimators are therefore estimating 
the conditional means of Y given X.
\code{svmRegression} is a simple alias of \code{lsSVM}.
}
\details{
This is the default for \code{\link{svm}} if the labels are not a factor.
}
\examples{
tt <- ttsplit(quakes)
model <- lsSVM(mag~., tt$train, display=1)
result <- test(model, tt$test)

errors(result) ## is the same as
mean( (tt$test$mag-result)^2 )
 
}
