% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{nplSVM}
\alias{nplSVM}
\title{Neyman-Pearson-Learning}
\usage{
nplSVM(x, y, ..., class = 1, constraint = 0.05,
  constraint.factors = c(3, 4, 6, 9, 12)/6, do.select = TRUE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{class}{is the normal class (the other class becomes the alarm class)}

\item{constraint}{gives the false alarm rate which should be achieved}

\item{constraint.factors}{specifies the factors around \code{constraint}}

\item{do.select}{if \code{TRUE} also does the whole selection for this model}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
This routine provides binary classifiers that satisfy a 
predefined error rate on one type of error and that 
simlutaneously minimize the other type of error. For 
convenience some points on the ROC curve around the 
predefined error rate are returned.
\code{nplNPL} performs Neyman-Pearson-Learning for classification.
}
\details{
Please look at the demo-vignette (\code{vignette('demo')}) for more examples.
The labels should only have value \code{c(1,-1)}.

\code{min_weight}, \code{max_weight}, \code{weight_steps}: you might have to define
which weighted classification problems will be considered.
The choice is usually a bit tricky. Good luck ...
}
\examples{
\dontrun{
model <- nplSVM(Y ~ ., 'banana-bc', display=1)

## a worked example can be seen at
vignette("demo",package="liquidSVM")
}
 
}
