% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-site.r
\name{ld_bundle_doc}
\alias{ld_bundle_doc}
\title{Create a `listdown` Document Bundle}
\usage{
ld_bundle_doc(cc, header, ld)
}
\arguments{
\item{cc}{the computational component list that will be presented.}

\item{header}{a `list` with the header information for the document.}

\item{ld}{a `listdown` object describing how to present the computational
components.}
}
\description{
A page bundle encapsulates the computational components, 
R Markdown header, and listdown object. Together, these three objects 
are sufficient to create a document, which can be written with the
`ld_create_document()` function.
}
\examples{
library(ggplot2)
cc <- list(
    iris = iris,
     Sepal.Length = list(
       Sepal.Width = ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width)) +
            geom_point(),
       Petal.Length = ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width)) +
            geom_point(),
     Colored = list(
          Sepal.Width = ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width,
            color = Species)) + geom_point(),
          Petal.Length = ggplot(iris, aes(x = Sepal.Length, y = Petal.Length,
            color = Species)) + geom_point())))

header <- ld_rmarkdown_header("Test header", author = "Some Dude",
                              date = "2020")

ld <- listdown(package = "ggplot2")

ld_bundle_doc(cc, header, ld)
}
\seealso{
ld_create_document
}
