% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_type_name}
\alias{is_type_name}
\title{Test Litter Data by Name}
\usage{
is_type_name(x)
}
\arguments{
\item{x}{\code{character} vector to check.}
}
\value{
\code{TRUE} if \code{x} complies with OSPAR, \code{FALSE} if not.
}
\description{
Checks if litter names are OSPAR compliant.
The OSPAR format consists of a litter category, a specification,
and an integer code in the range 000-989 in square brackets. In
addition the special code [TA] is allowed to specifiy total abundance.
}
\examples{
# valid litter type
stopifnot(is_type_name("Plastic: Food [6]"))

# invalid litter type: additional punctuation : and + are not allowed
stopifnot(!is_type_name("All cartons/tetrapaks [302:204+62+118]"))

# invalid litter type: numeric litter code is missing
stopifnot(!(is_type_name("no litter here")))

# invalid litter type: number greater than 989
stopifnot(!(is_type_name("Survey: Remarks [999]")))
stopifnot(!is_type_name("[TA]"))
}
