% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{plot_explanation}
\alias{plot_explanation}
\title{Plotting white box models.}
\usage{
plot_explanation(model, regr_plot_type = NULL, explained_instance = NULL,
  scale = "logit")
}
\arguments{
\item{model}{object returned by mlr::train function.}

\item{regr_plot_type}{Chr, "forestplot" or "waterfallplot" depending
on which type of plot is to be created.
if lm/glm model is used as interpretable approximation.}

\item{explained_instance}{Observation around which model was fitted.
Needed only if waterfall plot is drawn.}

\item{scale}{When probabilities are predicted, they can be plotted or "logit" scale 
or "probability" scale.}
}
\value{
plot (ggplot2 or base)
}
\description{
Plotting white box models.
}
\examples{
\dontrun{
# Forest plot for regression
plot_explanation(fitted_explanation1, "forestplot", wine[5, ])
# Waterfall plot
plot_explanation(fitted_explanation1, "waterfallplot", wine[5, ])
# Plot decision tree
plot_explanation(fitted_explanation2)
}

}
