/*
 * Decompiled with CFR 0.152.
 */
package shapleyComputation;

import java.math.BigInteger;

public class Combinations {
    private static long[][] pascalMatrix = null;

    public static long[][] initPascalMatrix(int n, int n2) {
        if (pascalMatrix == null || n > pascalMatrix.length) {
            if (pascalMatrix == null) {
                int n3;
                pascalMatrix = new long[n][n2];
                for (n3 = 0; n3 < n; ++n3) {
                    Combinations.pascalMatrix[n3][0] = 1L;
                }
                for (n3 = 1; n3 < n2; ++n3) {
                    Combinations.pascalMatrix[0][n3] = n3 + 1;
                }
                for (n3 = 1; n3 < n; ++n3) {
                    for (int i = 1; i < n2; ++i) {
                        Combinations.pascalMatrix[n3][i] = pascalMatrix[n3 - 1][i] + pascalMatrix[n3][i - 1];
                    }
                }
            } else {
                int n4;
                int n5;
                long[][] lArray = pascalMatrix;
                int n6 = lArray.length;
                int n7 = lArray[0].length;
                pascalMatrix = new long[n][n2];
                for (n5 = 0; n5 < n; ++n5) {
                    Combinations.pascalMatrix[n5][0] = 1L;
                }
                for (n5 = 1; n5 < n2; ++n5) {
                    Combinations.pascalMatrix[0][n5] = n5 + 1;
                }
                for (n5 = 1; n5 < n6; ++n5) {
                    for (n4 = 1; n4 < n7; ++n4) {
                        Combinations.pascalMatrix[n5][n4] = lArray[n5][n4];
                    }
                    for (n4 = n7; n4 < n2; ++n4) {
                        Combinations.pascalMatrix[n5][n4] = pascalMatrix[n5 - 1][n4] + pascalMatrix[n5][n4 - 1];
                    }
                }
                for (n5 = n6; n5 < n; ++n5) {
                    for (n4 = 1; n4 < n2; ++n4) {
                        Combinations.pascalMatrix[n5][n4] = pascalMatrix[n5 - 1][n4] + pascalMatrix[n5][n4 - 1];
                    }
                }
                lArray = null;
            }
        }
        return pascalMatrix;
    }

    public static long binomialCoefficient(int n, int n2) {
        if (n == n2) {
            return 1L;
        }
        Combinations.initPascalMatrix(n, n);
        return pascalMatrix[n - n2 - 1][n2];
    }

    public static int getSizeOfSubsetInBitFormat(int n, int n2) {
        return Integer.bitCount(n);
    }

    public static long getNumOfPartitions(int n) {
        long l = 0L;
        for (int i = 1; i <= n; ++i) {
            l += Combinations.getNumOfPartitionsOfCertainSize(n, i);
        }
        return l;
    }

    public static BigInteger getNumOfPartitions_bitIntegerVersion(int n) {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        for (int i = 1; i <= n; ++i) {
            bigInteger = bigInteger.add(Combinations.getNumOfPartitionsOfCertainSize_bigIntegerVersion(n, i));
        }
        return bigInteger;
    }

    public static long getNumOfPartitionsOfCertainSize(int n, int n2) {
        if (n2 == 1 || n2 == n) {
            return 1L;
        }
        return (long)n2 * Combinations.getNumOfPartitionsOfCertainSize(n - 1, n2) + Combinations.getNumOfPartitionsOfCertainSize(n - 1, n2 - 1);
    }

    public static BigInteger getNumOfPartitionsOfCertainSize_bigIntegerVersion(int n, int n2) {
        if (n2 == 1 || n2 == n) {
            return BigInteger.valueOf(1L);
        }
        BigInteger bigInteger = Combinations.getNumOfPartitionsOfCertainSize_bigIntegerVersion(n - 1, n2).multiply(BigInteger.valueOf(n2));
        bigInteger = bigInteger.add(Combinations.getNumOfPartitionsOfCertainSize_bigIntegerVersion(n - 1, n2 - 1));
        return bigInteger;
    }

    public static int convertSubsetFromByteToBitFormat(int[] nArray) {
        return Combinations.convertSubsetFromByteToBitFormat(nArray, nArray.length);
    }

    public static int convertSubsetFromByteToBitFormat(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += 1 << nArray[i] - 1;
        }
        return n2;
    }

    public static int[] convertSubsetFromBitToByteFormat(int n, int n2, int n3) {
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if ((n & 1 << i) == 0) continue;
            nArray[n4] = i + 1;
            ++n4;
        }
        return nArray;
    }

    public static int[] convertSubsetFromBitToByteFormat(int n, int n2) {
        int n3 = Combinations.getSizeOfSubsetInBitFormat(n, n2);
        return Combinations.convertSubsetFromBitToByteFormat(n, n2, n3);
    }

    public static int[][] convertSetOfSubsetsFromBitToByteFormat(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray2[i] = Combinations.getSizeOfSubsetInBitFormat(nArray[i], n);
        }
        return Combinations.convertSetOfSubsetsFromBitToByteFormat(nArray, n, nArray2);
    }

    public static int[][] convertSetOfSubsetsFromBitToByteFormat(int[] nArray, int n, int[] nArray2) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = Combinations.convertSubsetFromBitToByteFormat(nArray[i], n);
        }
        return nArrayArray;
    }

    public static int[] convertSetOfSubsetsFromByteToBitFormat(int[][] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Combinations.convertSubsetFromByteToBitFormat(nArray[i]);
        }
        return nArray2;
    }

    public static int[][] getSubsetsOfGivenSize(int n, int n2) {
        int n3;
        int[][] nArray = new int[(int)Combinations.binomialCoefficient(n, n2)][n2];
        int n4 = nArray.length - 1;
        for (n3 = 1; n3 <= n2; ++n3) {
            nArray[n4][n3 - 1] = n3;
        }
        n3 = n - n2 + 1;
        block1: while (n4 > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                int n5;
                if (nArray[n4][i] >= n3 + i) continue;
                --n4;
                for (n5 = 0; n5 < i; ++n5) {
                    nArray[n4][n5] = nArray[n4 + 1][n5];
                }
                nArray[n4][i] = nArray[n4 + 1][i] + 1;
                for (n5 = i + 1; n5 < n2; ++n5) {
                    nArray[n4][n5] = nArray[n4][n5 - 1] + 1;
                }
                continue block1;
            }
        }
        return nArray;
    }

    public static int[] getSubsetsOfGivenSizeInBitFormat(int n, int n2) {
        int n3;
        int[] nArray = new int[n + 1];
        for (int i = n; i > 0; --i) {
            nArray[i] = (1 << i) - 1;
        }
        int[] nArray2 = new int[(int)Combinations.binomialCoefficient(n, n2)];
        int n4 = nArray2.length - 1;
        nArray2[n4] = 0;
        for (n3 = 1; n3 <= n2; ++n3) {
            int n5 = n4;
            nArray2[n5] = nArray2[n5] + (1 << n3 - 1);
        }
        n3 = n - n2 + 1;
        block2: while (n4 > 0) {
            int n6 = n2 - 1;
            for (int i = n; i > 0; --i) {
                if ((nArray2[n4] & 1 << i - 1) == 0) continue;
                if (i < n3 + n6) {
                    nArray2[--n4] = nArray2[n4 + 1] & nArray[i - 1];
                    int n7 = n4;
                    nArray2[n7] = nArray2[n7] + (1 << i);
                    for (int j = 1; j < n2 - n6; ++j) {
                        int n8 = n4;
                        nArray2[n8] = nArray2[n8] + (1 << i + j);
                    }
                    --n6;
                    continue block2;
                }
                --n6;
            }
        }
        return nArray2;
    }

    public static void getPreviousSubset(int n, int n2, int[] nArray) {
        int n3 = n - n2 + 1;
        for (int i = n2 - 1; i >= 0; --i) {
            if (nArray[i] >= n3 + i) continue;
            int n4 = i;
            nArray[n4] = nArray[n4] + 1;
            for (int j = i + 1; j < n2; ++j) {
                nArray[j] = nArray[j - 1] + 1;
            }
            break;
        }
    }

    public static int getPreviousSubsetInBitFormat(int n, int n2, int n3) {
        int n4 = n2 - 1;
        int n5 = n - n2 + 1;
        for (int i = n; i > 0; --i) {
            if ((n3 & 1 << i - 1) == 0) continue;
            if (i < n5 + n4) {
                n3 &= (1 << i - 1) - 1;
                n3 += 1 << i;
                for (int j = 1; j < n2 - n4; ++j) {
                    n3 += 1 << i + j;
                }
                --n4;
                break;
            }
            --n4;
        }
        return n3;
    }

    public static void getNextSubset(int n, int n2, int[] nArray) {
        int n3;
        int n4 = n - n2 + 1;
        for (n3 = n2 - 1; n3 > 0; --n3) {
            if (nArray[n3] == nArray[n3 - 1] + 1) continue;
            int n5 = n3;
            nArray[n5] = nArray[n5] - 1;
            for (int i = n3 + 1; i < n2; ++i) {
                nArray[i] = n4 + i;
            }
            return;
        }
        nArray[0] = nArray[0] - 1;
        for (n3 = 1; n3 < n2; ++n3) {
            nArray[n3] = n4 + n3;
        }
    }

    public static int getPreviousSubsetInBitFormat2(int n, int n2, int n3) {
        int n4 = (n3 | n3 - 1) + 1;
        return n4 | ((n4 & -n4) / (n3 & -n3) >> 1) - 1;
    }

    public static int getNextSubsetInBitFormat(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = n2 - 1;
        int n7 = n - n2 + 1;
        for (n4 = n; n4 > 0; --n4) {
            if ((n3 & 1 << n4 - 1) == 0) continue;
            if ((n3 & 1 << n4 - 2) == 0) {
                n3 &= (1 << n4 - 1) - 1;
                n3 += 1 << n4 - 2;
                for (int i = n6 + 1; i < n2; ++i) {
                    n3 += 1 << n7 + i - 1;
                }
                return n3;
            }
            if (--n6 != 0) continue;
            n5 = n4 - 1;
            while ((n3 & 1 << n5 - 1) == 0) {
                --n5;
            }
            break;
        }
        n3 = 1 << n5 - 2;
        for (n4 = 1; n4 < n2; ++n4) {
            n3 += 1 << n7 + n4 - 1;
        }
        return n3;
    }

    public static int[] getSubsetAtGivenIndex(int n, int n2, int n3) {
        ++n2;
        Combinations.initPascalMatrix(n3 + 1, n3 + 1);
        int[] nArray = new int[n];
        boolean bl = false;
        int n4 = 1;
        int n5 = n;
        do {
            int n6 = 1;
            while (pascalMatrix[n5 - 1][n6 - 1] < (long)n2) {
                ++n6;
            }
            nArray[n4 - 1] = n3 - n5 + 1 - n6 + 1;
            if (pascalMatrix[n5 - 1][n6 - 1] == (long)n2) {
                for (int i = n4; i <= n - 1; ++i) {
                    nArray[i] = nArray[i - 1] + 1;
                }
                bl = true;
                continue;
            }
            ++n4;
            n2 = (int)((long)n2 - pascalMatrix[n5 - 1][n6 - 2]);
            --n5;
        } while (!bl);
        return nArray;
    }

    public static int getIndexOfSubset(int[] nArray, int n, int n2) {
        long l = 0L;
        if (n == 1) {
            l = n2 - nArray[0] + 1;
        } else {
            boolean bl = true;
            for (int i = n - 1; i >= 1; --i) {
                if (nArray[i] - nArray[i - 1] <= 1) continue;
                l = pascalMatrix[n - i - 1][n2 - n + i - nArray[i] + 1];
                for (int j = i - 1; j >= 0; --j) {
                    l += pascalMatrix[n - j - 1][n2 - n + j - nArray[j]];
                }
                bl = false;
                break;
            }
            if (bl) {
                l = pascalMatrix[n - 1][n2 - n - nArray[0] + 1];
            }
        }
        return (int)l - 1;
    }
}

