% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clmdu.R
\name{plot.clmdu}
\alias{plot.clmdu}
\title{Plots a Cumulative Logistic MDU model}
\usage{
\method{plot}{clmdu}(
  x,
  dims = c(1, 2),
  circles = seq(1, R),
  ycol = "darkgreen",
  xcol = "lightskyblue",
  ocol = "grey",
  ...
)
}
\arguments{
\item{x}{an object of type clmdu}

\item{dims}{which dimensions to visualize}

\item{circles}{which circles to visualize}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from clmdu
}
\description{
Plots a Cumulative Logistic MDU model
}
\examples{
\dontrun{
data(dataExample_clmdu)
Y = as.matrix(dataExample_clmdu[ , 1:8])
X = as.matrix(dataExample_clmdu[ , 9:13])
# unsupervised
output = clmdu(Y = Y, S = 2)
plot(output)
}


}
