### $Id: Spruce.q,v 1.3 1998/04/10 22:52:06 bates Exp $
### Spruce tree growth under different conditions
### Diggle, Liang and Zeger (1994), Table 1.2, pp. 6-7
"Spruce" <-
  structure(list
  (Tree = structure(ordered(c(23, 23, 23, 23, 23, 
     23, 23, 23, 23, 23, 23, 23, 23, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
     8, 8, 8, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
     15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 26, 26, 26, 
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 24, 24, 24, 24, 24, 24, 
     24, 24, 24, 24, 24, 24, 24, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
     22, 22, 22, 22, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
     18, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 5, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
     9, 9, 9, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
     19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 13, 13, 13, 
     13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 25, 
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 
     10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 14, 14, 14, 14, 14, 14, 
     14, 14, 14, 14, 14, 14, 14, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
     20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 16, 
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 6, 6, 6, 6, 6, 6, 
     6, 6, 6, 6, 6, 6, 6, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
     12, 12, 12, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
     52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 49, 49, 49, 
     49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 33, 33, 33, 33, 33, 33, 
     33, 33, 33, 33, 33, 33, 33, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
     43, 43, 43, 43, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
     34, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 54, 54, 
     54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 30, 30, 30, 30, 30, 
     30, 30, 30, 30, 30, 30, 30, 30, 53, 53, 53, 53, 53, 53, 53, 53, 
     53, 53, 53, 53, 53, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 
     48, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 46, 
     46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 51, 51, 51, 51, 
     51, 51, 51, 51, 51, 51, 51, 51, 51, 38, 38, 38, 38, 38, 38, 38, 
     38, 38, 38, 38, 38, 38, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 
     45, 45, 45, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 
     28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 47, 47, 47, 
     47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 41, 41, 41, 41, 41, 41, 
     41, 41, 41, 41, 41, 41, 41, 36, 36, 36, 36, 36, 36, 36, 36, 36, 
     36, 36, 36, 36, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 
     32, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 37, 37, 
     37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 39, 39, 39, 39, 39, 
     39, 39, 39, 39, 39, 39, 39, 39, 31, 31, 31, 31, 31, 31, 31, 31, 
     31, 31, 31, 31, 31, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 
     35, 35, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 65, 
     65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 59, 59, 59, 59, 
     59, 59, 59, 59, 59, 59, 59, 59, 59, 63, 63, 63, 63, 63, 63, 63, 
     63, 63, 63, 63, 63, 63, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 
     62, 62, 62, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 
     66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 58, 58, 58, 
     58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 56, 56, 56, 56, 56, 56, 
     56, 56, 56, 56, 56, 56, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 
     55, 55, 55, 55, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 
     61, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 77, 77, 
     77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 71, 71, 71, 71, 71, 
     71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, 72, 
     72, 72, 72, 72, 72, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 
     76, 76, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 74, 
     74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75, 
     75, 75, 75, 75, 75, 75, 75, 75, 75, 73, 73, 73, 73, 73, 73, 73, 
     73, 73, 73, 73, 73, 73, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 
     70, 70, 70, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 
     67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 78, 78, 78, 
     78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 69, 69, 69, 69, 69, 69, 
     69, 69, 69, 69, 69, 69, 69), levels=1:79),
     class = c("ordered", "factor"),
     .Label = c("O1T24", "O1T18", "O1T19", "O1T15", "O1T10", 
       "O1T26", "O1T16", "O1T02", "O1T11", "O1T21", "O1T20", "O1T27", 
       "O1T14", "O1T22", "O1T04", "O1T25", "O1T12", "O1T08", "O1T13", 
       "O1T23", "O1T03", "O1T07", "O1T01", "O1T06", "O1T17", "O1T05", 
       "O1T09", "O2T18", "O2T23", "O2T09", "O2T26", "O2T22", "O2T04", 
       "O2T06", "O2T27", "O2T21", "O2T24", "O2T15", "O2T25", "O2T01", 
       "O2T20", "O2T17", "O2T05", "O2T07", "O2T16", "O2T13", "O2T19", 
       "O2T11", "O2T03", "O2T12", "O2T14", "O2T02", "O2T10", "O2T08", 
       "N1T10", "N1T09", "N1T12", "N1T08", "N1T03", "N1T01", "N1T11", 
       "N1T05", "N1T04", "N1T06", "N1T02", "N1T07", "N2T11", "N2T10", 
       "N2T13", "N2T09", "N2T02", "N2T03", "N2T08", "N2T06", "N2T07", 
       "N2T04", "N2T01", "N2T12", "N2T05")),
   days = c(152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674, 152, 174, 201, 
     227, 258, 469, 496, 528, 556, 579, 613, 639, 674),
   logSize = c(4.51, 
     4.98, 5.41, 5.9, 6.15, 6.16, 6.18, 6.48, 6.65, 6.87, 6.95, 6.99, 
     7.04, 4.24, 4.2, 4.68, 4.92, 4.96, 5.2, 5.22, 5.39, 5.65, 5.71, 
     5.78, 5.82, 5.85, 3.98, 4.36, 4.79, 4.99, 5.03, 5.87, 5.88, 6.04, 
     6.34, 6.49, 6.58, 6.65, 6.61, 4.36, 4.77, 5.1, 5.3, 5.36, 5.53, 
     5.56, 5.68, 5.93, 6.21, 6.26, 6.2, 6.19, 4.34, 4.95, 5.42, 5.97, 
     6.28, 6.5, 6.5, 6.79, 6.83, 7.1, 7.17, 7.21, 7.16, 4.59, 5.08, 
     5.36, 5.76, 6, 6.33, 6.34, 6.39, 6.78, 6.91, 6.99, 7.01, 7.05, 
     4.41, 4.56, 4.95, 5.23, 5.33, 6.13, 6.14, 6.36, 6.57, 6.78, 6.82, 
     6.81, 6.86, 4.24, 4.64, 4.95, 5.38, 5.48, 5.61, 5.63, 5.82, 6.18, 
     6.42, 6.48, 6.47, 6.46, 4.82, 5.17, 5.76, 6.12, 6.24, 6.48, 6.5, 
     6.77, 7.14, 7.26, 7.3, 6.91, 7.28, 3.84, 4.17, 4.67, 4.67, 4.8, 
     4.94, 4.94, 5.05, 5.33, 5.53, 5.56, 5.57, 5.6, 4.07, 4.31, 4.9, 
     5.1, 5.1, 5.26, 5.26, 5.38, 5.66, 5.81, 5.84, 5.93, 5.89, 4.28, 
     4.8, 5.27, 5.55, 5.65, 5.76, 5.77, 5.98, 6.18, 6.39, 6.43, 6.44, 
     6.41, 4.47, 4.89, 5.23, 5.55, 5.74, 5.99, 6.01, 6.08, 6.39, 6.45, 
     6.57, 6.57, 6.58, 4.46, 4.84, 5.11, 5.34, 5.46, 5.47, 5.49, 5.7, 
     5.93, 6.06, 6.15, 6.12, 6.12, 4.6, 4.08, 4.17, 4.35, 4.59, 4.65, 
     4.69, 5.01, 5.21, 5.38, 5.58, 5.46, 5.5, 3.73, 4.15, 4.61, 4.87, 
     4.93, 5.24, 5.25, 5.25, 5.45, 5.65, 5.65, 5.76, 5.83, 4.67, 4.88, 
     5.18, 5.34, 5.49, 6.44, 6.44, 6.61, 6.74, 7.06, 7.11, 7.04, 7.11, 
     2.96, 3.47, 3.76, 3.89, 4.3, 4.15, 4.15, 4.41, 4.72, 4.76, 4.93, 
     4.98, 5.07, 3.24, 3.93, 4.76, 4.62, 4.64, 4.63, 4.64, 4.77, 5.08, 
     5.27, 5.3, 5.43, 5.2, 4.36, 4.77, 5.02, 5.26, 5.45, 5.44, 5.44, 
     5.49, 5.73, 5.77, 6.01, 5.96, 5.96, 4.04, 4.64, 4.86, 5.09, 5.25, 
     5.25, 5.27, 5.5, 5.65, 5.69, 5.97, 5.97, 5.89, 3.53, 4.25, 4.68, 
     4.97, 5.18, 5.64, 5.64, 5.53, 5.74, 5.78, 5.94, 6.18, 5.99, 4.22, 
     4.69, 5.07, 5.37, 5.58, 5.76, 5.8, 6.11, 6.37, 6.35, 6.58, 6.55, 
     6.55, 2.79, 3.1, 3.3, 3.38, 3.55, 3.61, 3.65, 3.93, 4.18, 4.13, 
     4.36, 4.43, 4.39, 3.3, 3.9, 4.34, 4.96, 5.4, 5.46, 5.49, 5.77, 
     6.03, 6.07, 6.2, 6.26, 6.28, 3.34, 3.81, 4.21, 4.54, 4.86, 4.93, 
     4.96, 5.15, 5.48, 5.49, 5.7, 5.74, 5.74, 3.76, 4.36, 4.7, 5.44, 
     5.32, 5.65, 5.67, 5.63, 6.04, 6.02, 6.05, 6.03, 5.91, 4.49, 4.76, 
     5.15, 5.37, 5.56, 5.73, 5.73, 5.8, 5.97, 6.1, 6.16, 6.22, 6.13, 
     4.88, 5.14, 5.52, 6.08, 6.17, 6.32, 6.33, 6.37, 6.68, 6.83, 6.94, 
     6.93, 6.95, 4.88, 5.32, 5.63, 5.75, 5.94, 6.09, 6.09, 6.14, 6.51, 
     6.61, 6.68, 6.64, 6.74, 3.8, 4.16, 4.45, 4.89, 5.05, 5.06, 5.06, 
     5.13, 5.32, 5.46, 5.46, 5.42, 5.49, 4.46, 4.62, 5, 5.4, 5.49, 
     5.68, 5.72, 5.95, 6.13, 6.32, 6.33, 6.33, 6.3, 4.29, 4.82, 5.32, 
     5.46, 5.5, 5.54, 5.54, 5.54, 5.6, 5.57, 5.55, 5.55, 5.55, 4.06, 
     4.58, 4.81, 5.12, 5.27, 5.48, 5.51, 5.58, 5.93, 6.36, 6.17, 6.07, 
     6.13, 5.16, 5.43, 5.71, 6.08, 6.21, 6.37, 6.38, 6.41, 6.64, 6.82, 
     6.89, 7.11, 7.14, 3.81, 4.12, 4.42, 4.62, 4.6, 4.74, 4.76, 4.94, 
     5.1, 5.21, 5.23, 5.22, 5.23, 5.09, 5.62, 5.9, 6.36, 6.49, 6.72, 
     6.72, 6.74, 6.87, 6.87, 6.87, 6.83, 6.97, 4.13, 4.71, 5.27, 5.56, 
     5.72, 6.06, 6.06, 6.21, 6.44, 6.66, 6.71, 6.65, 6.64, 4.85, 5.36, 
     5.52, 5.96, 6.13, 6.22, 6.24, 6.41, 6.58, 6.78, 6.83, 6.82, 6.8, 
     4.11, 4.62, 4.95, 5.28, 5.43, 5.8, 5.8, 5.87, 6.2, 6.44, 6.44, 
     6.4, 6.44, 4.95, 5.39, 5.82, 6.42, 6.48, 6.61, 6.61, 6.66, 6.73, 
     6.83, 6.9, 6.83, 6.63, 4.36, 4.65, 5.04, 5.38, 5.47, 5.48, 5.48, 
     5.47, 5.84, 5.97, 5.93, 5.95, 6.01, 4.05, 4.65, 5.09, 5.44, 5.6, 
     5.79, 5.8, 6.07, 6.14, 6.3, 6.32, 6.34, 6.42, 3.76, 4.27, 4.59, 
     5.1, 5.25, 5.41, 5.44, 5.48, 5.93, 5.97, 6.08, 6.29, 6.24, 2.84, 
     3.25, 3.69, 4.16, 4.21, 4.3, 4.3, 4.45, 4.59, 4.74, 4.84, 4.64, 
     4.64, 4.33, 4.8, 5.09, 5.42, 5.61, 5.85, 5.88, 6.01, 6.22, 6.45, 
     6.55, 6.55, 6.55, 3.99, 4.55, 4.91, 5.26, 5.3, 5.69, 5.69, 5.9, 
     5.89, 5.98, 6.05, 6.25, 6.25, 3.5, 3.75, 3.97, 4.71, 4.85, 5.01, 
     5.02, 5.27, 5.45, 5.59, 5.67, 5.83, 5.86, 3.31, 3.45, 4.16, 4.48, 
     4.54, 4.72, 4.74, 4.93, 5.07, 5.26, 5.26, 5.35, 5.35, 3.03, 3.55, 
     3.97, 4.4, 4.58, 4.47, 4.47, 4.66, 4.8, 5.1, 5.08, 5.12, 5.12, 
     3.27, 3.83, 4.44, 4.8, 4.89, 5.08, 5.09, 5.34, 5.63, 5.81, 5.93, 
     5.94, 5.94, 3.56, 4.18, 4.7, 5.27, 5.28, 5.5, 5.5, 5.77, 5.98, 
     6.05, 6.19, 6.14, 6.14, 3.39, 3.73, 3.92, 4.11, 4.15, 4.49, 4.52, 
     4.82, 5.18, 5.26, 5.32, 5.28, 5.28, 3.72, 4.16, 4.55, 5.03, 5.02, 
     5.16, 5.16, 5.28, 5.52, 5.7, 5.7, 5.67, 5.67, 4.53, 5.05, 5.18, 
     5.41, 5.42, 5.71, 5.71, 5.96, 6.17, 6.34, 6.44, 6.46, 6.43, 4.97, 
     5.32, 5.83, 6.29, 6.45, 6.61, 6.61, 6.79, 7.13, 7.24, 7.32, 7.29, 
     7.35, 4.37, 4.81, 5.03, 5.19, 5.4, 5.57, 5.59, 5.82, 6.03, 6.17, 
     6.32, 6.25, 6.29, 4.58, 4.99, 5.37, 5.68, 5.93, 6.14, 6.17, 6.43, 
     6.56, 6.69, 6.81, 6.82, 6.76, 4, 4.5, 4.92, 5.44, 5.87, 6.02, 
     6.04, 6.11, 6.47, 6.61, 6.66, 6.7, 6.65, 4.73, 5.05, 5.33, 5.92, 
     6.01, 6.26, 6.26, 6.36, 6.49, 6.63, 6.92, 6.92, 6.92, 5.15, 5.63, 
     6.11, 6.39, 6.61, 6.82, 6.82, 6.95, 7.11, 7.44, 7.53, 7.46, 7.56, 
     4.1, 4.46, 4.84, 5.29, 5.48, 5.68, 5.68, 5.85, 5.99, 6.08, 6.25, 
     6.15, 6.18, 3.22, 3.85, 4.47, 4.85, 5.11, 5.28, 5.28, 5.45, 5.74, 
     5.95, 6.05, 6.07, 6.02, 2.23, 2.89, 3.16, 3.4, 3.52, 3.89, 3.93, 
     4.22, 4.51, 4.65, 4.7, 4.73, 4.68, 3.65, 4.36, 4.76, 5.18, 5.44, 
     5.7, 5.7, 5.89, 6.09, 6.39, 6.57, 6.36, 6.44, 3.4, 3.92, 4.5, 
     4.97, 5.14, 5.34, 5.35, 5.61, 5.83, 6.03, 6.09, 5.98, 5.95, 5.16, 
     5.49, 5.74, 6.05, 6.21, 6.37, 6.37, 6.52, 6.65, 6.86, 6.87, 6.88, 
     6.84, 4.04, 4.52, 5.15, 5.59, 5.87, 5.96, 5.96, 6.17, 6.37, 6.53, 
     6.6, 6.52, 6.59, 4.52, 4.91, 5.04, 5.71, 5.97, 6.11, 6.12, 6.24, 
     6.44, 6.54, 6.65, 6.63, 6.64, 4.56, 5.12, 5.4, 5.69, 5.89, 6.16, 
     6.17, 6.13, 6.44, 6.72, 6.81, 6.87, 6.8, 4.9, 5.35, 5.71, 6.12, 
     6.25, 6.39, 6.39, 6.52, 6.86, 7.05, 7.09, 6.9, 6.88, 4.83, 5.1, 
     5.43, 5.59, 6.04, 6.21, 6.21, 6.46, 6.45, 6.59, 6.7, 6.63, 6.66, 
     5.46, 5.79, 6.12, 6.41, 6.63, 6.73, 6.73, 6.77, 6.68, 6.75, 6.75, 
     6.62, 6.6, 4.17, 4.67, 5.16, 5.56, 5.75, 6, 6.02, 6.14, 6.28, 
     6.55, 6.66, 6.63, 6.63, 3.35, 4.05, 4.51, 5.22, 5.44, 5.79, 5.82, 
     6.05, 6.29, 6.22, 6.39, 6.47, 6.42, 3.33, 3.82, 4.38, 4.99, 5.17, 
     5.4, 5.4, 5.73, 5.85, 5.75, 5.99, 6.1, 6.15, 3.41, 3.68, 4.03, 
     4.28, 4.54, 4.52, 4.57, 5.01, 5.13, 5.11, 5.3, 5.46, 5.35, 4.5, 
     4.8, 5.28, 5.83, 6.16, 6.33, 6.34, 6.56, 6.63, 6.75, 6.89, 6.96, 
     6.94, 2.99, 3.61, 4.48, 4.91, 5.06, 5.23, 5.25, 5.56, 5.95, 5.98, 
     6.21, 6.28, 6.34),
   plot = structure(factor(c(1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4), levels=1:4),
     class = "factor",
     .Label = c("1", "2", "3", "4"))),
row.names = 1:1027,
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = logSize ~ days | Tree,
labels = list(x = "Time since planting", y = "log(Size)"),
units = list(x = "(days"))
