% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.noise-method.R
\name{plot.noise}
\alias{plot.noise}
\title{Plot of \code{associations} objects}
\usage{
\method{plot}{noise}(x, colorBy = "propMissing", fcCutoff = NA,
  propMissingCutoff = NA, ...)
}
\arguments{
\item{x}{an object of class \code{matrix} or \code{data.frame}.}

\item{colorBy}{\code{associations} the variable to be colored by.  Default  \code{'propMissing'}, options: \code{'propMissing'},\code{'fc'}.}

\item{fcCutoff}{an optional \code{numeric} value to remove ratios with low fold changes.}

\item{propMissingCutoff}{an optional \code{numeric} value to remove ratios with high number of missing values.}

\item{\ldots}{ignored}
}
\value{
plot showing filter ratios R_T and R_I as proposed by Straube \emph{et al.} 2014. Filter ratios can either be colored by proportion of missing values or maximum fold change.
}
\description{
Plot of the filter ratios R_T and R_I as proposed by Straube et al 2014.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
G1 <- kidneySimTimeGroup$group=="G1"
noiseTest <-investNoise(data=kidneySimTimeGroup$data[G1,],time=kidneySimTimeGroup$time[G1],
            sampleID=kidneySimTimeGroup$sampleID[G1])
plot(noiseTest,colorBy="fc")
}
}
\references{
Straube J., Gorse D., Huang B.E., Le Cao K.-A.(2014).  \emph{A linear mixed model spline framework for analyzing time course 'omics' data} Submitted
}
\seealso{
\code{\link{investNoise}}, \code{\link{filterNoise}}
}

