% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.lmvar.R
\name{AIC.lmvar}
\alias{AIC.lmvar}
\title{AIC for an object of class 'lmvar'}
\usage{
\method{AIC}{lmvar}(object, ..., k = 2)
}
\arguments{
\item{object}{Object of class 'lmvar'}

\item{...}{For compatibility with \code{\link[stats]{AIC}} generic}

\item{k}{Numeric, the penalty per parameter to be used. The default k = 2 is the classical AIC.}
}
\value{
the AIC of the object
}
\description{
AIC (Aikaike's 'An Information Criterion') for an object of class 'lmvar'
}
\examples{
\dontrun{

# Let 'fit' be an object of class 'lmvar'. The classical AIC is
AIC(fit)

# To calculate the AIC with penalty-parameter k = 3 run
AIC(fit, k = 3)
}
}
