% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qdis_lmlike.R
\name{plot_qdis_lmlike}
\alias{plot_qdis_lmlike}
\title{Plot of the distribution of quantiles for objects of class 'lm' or 'lmvar'}
\usage{
plot_qdis_lmlike(object_1, object_2 = NULL, name_1, name_2 = NULL)
}
\arguments{
\item{object_1}{Object of class 'lm' or 'lmvar'}

\item{object_2}{Object of class 'lm' or class 'lmvar'}

\item{name_1}{Character string, the name of \code{object_1}}

\item{name_2}{Character string, the name of \code{object_2}}
}
\description{
Function produces a histogram of quantiles for  objects of
class 'lm' or 'lmvar'. This function is called by \code{\link{plot_qdis.lm}} and
\code{\link{plot_qdis.lmvar}}. It is not intended to be called directly.
}
\details{
If \code{object_2} is specified, a plot for \code{object_1} and one for \code{object_2} will be
combined in the same plot.

The string \code{name_1} and (optionally) \code{name_2} are used in the legend of the plot as names for
\code{object_1} and (optionally) \code{object_2}.

All inputs of class 'lm' must contain the response vector \eqn{y}. I.e., one must run \code{\link[stats]{lm}}
with argument \code{y = TRUE}.
}
