\name{4.1.panel.pal}
\alias{4.1.panel.pal}
\alias{panelPal.old}
\alias{panelPal}
\alias{loaHandler}

\title{
  panelPal
}
\description{
  \code{lattice} plot management using the \code{loa} function \code{panelPal}
}
\usage{

panelPal(ans, panel = NULL, preprocess = FALSE, 
         reset.xylims = FALSE, legend = NULL,
         by.group = NULL, by.zcase = NULL, ...)

panelPal.old(x, y, subscripts, at, col.regions, ..., 
         panel = panel.xyplot, ignore = NULL, 
         group.fun = NULL)

loaHandler(panel = NULL,...)


}

\arguments{


 \item{ans}{ For \code{panelPal} only, a stanard \code{trellis} object, such 
   as that generated by \code{\link{lattice}} function \code{\link{xyplot}}.  
  }

 \item{panel}{ A panel function, e.g. \code{panel.xyplot}. If supplied in 
   \code{panelPal} call, typically the one used to generate \code{ans}. If 
   supplied in \code{panelPal.old}, the panel that is intended to used 
   when generating a plot.  
  } 

 \item{preprocess, reset.xylims, legend, by.group, by.zcase}{ For 
  \code{panelPal} only, \code{loa} plot management arguments. 
  \code{proprocess}: Logical, should the supplied \code{panel} function 
  be preprocessed? \code{reset.xylims}: Logical, should the plot dimensions 
  be reset if changed, e.g. by preprocessing? \code{legend}: the legend as 
  with standard \code{lattice} plots, \code{by.group}: a vector of plot 
  argument names to be linked to any group conditioning, \code{by.zcase}: 
  a vector of plot argument names to be linked to any z case conditioning     
  See Details below. 
  }

  \item{...}{ Additional arguments, typically passed on.
  } 


  \item{x,y,subscripts,at,col.regions}{ For \code{panelPal.old} only, 
   panel arguments passed down to individual panels. 
   }

 \item{ignore}{ Any additional arguments that \code{panelPal.old} 
  should ignore and pass on to \code{panel} unchecked/unmodified. 
  } 

 \item{group.fun}{ Fine control of the standard \code{lattice} 
  plot argument \code{group}. It can be a vector or list containing the 
  same number of elements as there as groups. These can be functions (or 
  the names of functions as characters) setting individual functions for 
  group or sets of parameters to be evaluated using the \code{panel} 
  function. For example, the current \code{NULL} default generates a list 
  of \code{col} and \code{pch} settings that produce a conventional grouped 
  scatter plot output when the \code{group} argument is applied to the 
  \code{panel} default \code{panel.xyplot}. See Details below. 
  }


} 


\details{

  \code{panelPal} provides a range of generic plot management features. 

   Firstly, it allows plot as well as panel defaults to be managed by the 
   \code{panel...} function. This allows the panel developer to control 
   plot-level components of the plot output, e.g. which key to use with the 
   plot and what default settings to apply to it. See example 1 below.

   Secondly, it uses a generalised extension of the subscripting methods described 
   by Deepayan Sarkar in Chapter 5 of Lattice (see sections on scatterplots and 
   extensions) to automatically handle plot argument subscripting, demonstrated 
   in example 2 below. 

   Thirdly, it applies an extension of the method used by the hexbin lattice panel 
   to pass hex cell counts (calculated in panels) to the plot key and standardise 
   the assignment of associated parameters within all panels to provide more 
   general panel-to-panel and panel-to-scale. The method is briefly discussed in 
   Chapter 14 of Sarkar. 

   This method has also been extended by isolating processing and plot components 
   of the \code{panel...} function operation allowing results of any calculations 
   made in-panel to be retained rather than lost when plot is generated.

   Fourly, \code{group...} and \code{zcase...} arguments can used to manage plot 
   group and zcase based plot outputs.   
  
   Some \code{panelPal} are implemented if specially structured (or loa-friendly) 
   \code{panel...} functions are supplied. These are illustrated in the final 
   example below.

  \code{loaHandler} is a workhorse that assesses information in 'loa' friendly 
  \code{panel...} functions. As well as checking this, \code{loaHandler} also 
  checks the supplied panel for any default plot settings. This allows users to 
  manage the appearance of a plot from the panel or automatically associated 
  color keys.  

}

\value{

   Both \code{panelPal} and \code{panelPal.old} are intended to be used with 
   \code{trellis} plot outputs.

   \code{panelPal} should be employed retrospectively. So, for example:

   \code{p1 <- xyplot(...)}\cr
   \code{panelPanel(p1, ...)}

   The previous version, currently retained as \code{panelPal.old}, was employed 
   developed as a \code{panel...} function wrapper and intended to be employed 
   within the plot call. So, for example:

   \code{xyplot(..., panel = function(...) panelPal(..., panel=panel))} 

   Because it is run within the plot call, and therefore within each panel called, 
   it does not provide features that require panel-to-plot, panel-to-key or 
   panel-to-panel communication.

  \code{loaHandler} returns either a logical (\code{FALSE} if not loa 'friendly'; 
  \code{TRUE} if loa 'friendly') or a list of default arguments to be used when 
  plotting. 

}

\references{
  These function makes extensive use of code developed by others.  

  lattice:\cr
  Sarkar, Deepayan (2008) Lattice: Multivariate Data
  Visualization with R. Springer, New York. ISBN
  978-0-387-75968-5

  hexbin:\cr
  Dan Carr, ported by Nicholas Lewin-Koh and Martin Maechler (2013).
  hexbin: Hexagonal Binning Routines. R package version 1.26.2.
  http://CRAN.R-project.org/package=hexbin

  \code{panelPal.old} and \code{panelPal} both apply an extension 
  of the subscripting methods described by Deepayan Sarkar in Chapter 
  5 of Lattice (see sections on scatterplots and extensions) to 
  automatically handle plot argument subscripting.

  \code{panelPal} applies an extension of the method used by 
  hex bin lattice panel to comunicate hex cell counts (calculated 
  in panels) panel-to-panel and panel-to-scale. The method is 
  briefly discussed in Chapter 14 of Sarkar.

}

\author{
  Karl Ropkins
}

\note{
 The \code{by.group} and \code{by.zcase} arguments of \code{panelPal} and 
 the \code{group.fun} argument of \code{panelPal.old} are all currently 
 under review. Please do not use these.

}

\seealso{
   \code{\link{lattice}}, \code{\link{xyplot}},
}

\examples{

## the combination of panelPal and specially 
## structured panel... functions provides 
## several additional plot features:

## example 1
## plot management from the panel... functions.

# loaHandler can used to see if a panel is loa-friendly

loaHandler(panel.xyplot)  #FALSE
loaHandler(panel.loaPlot) #panel defaults

# note that these include a list called 
# default.settings. These are settings that are  
# automatically added to the plot call.

# Here this assigns a specialist key to that 
# panel. However, the same mechanism can also 
# be used to turn off plot elements like the 
# standard lattice axes, when using in panel 
# alternatives

# first some silly data

a <- rnorm(1000)
b <- rnorm(1000)

# now compare:  

# default plot 
# note bubble plot style key

loaPlot(a~a*b) 

# bin plot
# with classic color key

loaPlot(a~a*b, panel = panel.binPlot) 

 
## example 2
## automatic subscripting with loa

# Other arguments are not automatically 
# aligned with the main plots. 

# For example, consider the data:

a <- 1:10
ref <- rep(1:2, each=5)

# and associated lattice xyplot output:

xyplot(a~a|ref, col=ref, pch=19)

# Here, the 'col' argument does not 
# automatically track plot conditioning. 

# With lattice plots you need to assign
# arguments you want to track in this 
# manner using subscripts, as discussed 
# in Lattice Chapter 5.

# Now compare a similar loaPlot:

loaPlot(~a*a|ref, col=ref, pch=19)

# Here, panelPal automatically handles 
# such subscripting. It extends this 
# assumption to all supplied arguments.  

# For example, try
\dontrun{
  loaPlot(~a*a|ref, col=ref, pch=ref)
  loaPlot(~a*a|ref, col=ref, pch=1:10)}

}


\keyword{ methods }
