% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHI.R
\name{SHI}
\alias{SHI}
\title{Calculate Simple Hysteresis Index (SHI)}
\usage{
SHI(dataframe, q, ssc, .warn = TRUE)
}
\arguments{
\item{dataframe}{A data set object.}

\item{q}{numeric, water discharge variable.}

\item{ssc}{numeric, suspended sediment concentration variable.}

\item{.warn}{logical, indicating if the warning message should be displayed.}
}
\value{
A numeric variable
}
\description{
This function calculates Simple Hysteresis Index (SHI)
following the description from \emph{Tsyplenkov et al.} (2020)
}
\examples{
library(dplyr)
data(djan)
output_table <- hydro_events(dataframe = djan,
                             q = discharge,
                             datetime = time,
                             window = 21)

output_table \%>\%
  filter(he == 2) \%>\%
  SHI(q = discharge, ssc = SS)
}
\references{
Tsyplenkov A, Vanmaercke M, Golosov V, Chalov S. 2020. Suspended sediment budget and intra-event sediment dynamics of a small glaciated mountainous catchment in the Northern Caucasus. Journal of Soils and Sediments 20 (8): 3266–3281 DOI: 10.1007/s11368-020-02633-z
}
\author{
Matthias Vanmaercke and Anatoly Tsyplenkov
}
