% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hysteresis_plot.R
\name{hysteresis_plot}
\alias{hysteresis_plot}
\title{Plot Q-SSC hysteresis plot}
\usage{
hysteresis_plot(
  dataframe,
  datetime,
  q,
  ssc,
  base_font_size = 12,
  legend = "bottom",
  ...
)
}
\arguments{
\item{dataframe}{A data set object}

\item{datetime}{Datetime variable (column in POSIXct format), optional}

\item{q}{Water discharge variable (or water stage)}

\item{ssc}{Suspended sediment concentration variable}

\item{base_font_size}{Font size (numeric, 12 by default)}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{...}{Other arguments passed to \code{ggpubr::theme_pubclean}}
}
\value{
A \code{ggplot2} object
}
\description{
This function plots a water discharge (\code{Q}) and suspended
sediment concentration (\code{SSC}) relationship.
}
\examples{
library(dplyr)
library(ggplot2)
data(djan)
output_table <- hydro_events(
  dataframe = djan,
  q = discharge,
  datetime = time,
  window = 21
)

output_table \%>\%
  filter(he == 2) \%>\%
  hysteresis_plot(q = discharge, ssc = SS)
}
