% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ast.R
\name{ast}
\alias{ast}
\title{Display the abstract syntax tree}
\usage{
ast(x)
}
\arguments{
\item{x}{An expression to display. Input is automatically quoted,
use \code{!!} to unquote if you have already captured an expression object.}
}
\description{
This is a useful alternative to \code{str()} for expression objects.
}
\examples{
# Leaves
ast(1)
ast(x)

# Simple calls
ast(f())
ast(f(x, 1, g(), h(i())))
ast(f()())
ast(f(x)(y))

ast((x + 1))

# Displaying expression already stored in object
x <- quote(a + b + c)
ast(x)
ast(!!x)

# All operations have this same structure
ast(if (TRUE) 3 else 4)
ast(y <- x * 10)
ast(function(x = 1, y = 2) { x + y } )

# Operator precedence
ast(1 * 2 + 3)
ast(!1 + !1)
}
