% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectreg_loclin_trivariate.R
\name{expectreg_loclin_trivariate}
\alias{expectreg_loclin_trivariate}
\title{Local linear expectile regression (iterative procedure) for
a trivariate covariate case}
\usage{
expectreg_loclin_trivariate(Z, X1, X2, Y, omega, h, kernel = gaussK)
}
\arguments{
\item{Z}{The first covariate data values.}

\item{X1}{The second covariate data values.}

\item{X2}{The third covariate data values.}

\item{Y}{The response data values.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}

\item{h}{Smoothing parameter, bandwidth.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}
}
\value{
\code{\link{expectreg_loclin_trivariate}} local linear expectile estimator
proposed and studied by Adam and Gijbels (2021b) for a trivariate covariate matrix.
\code{\link{expectreg_loclin_trivariate}} returns a vector whose components are
the estimation of the nonparametric part according to the observed values
(i.e. \eqn{(Z_i,X_{1i},X_{2i})}).
}
\description{
Formula interface for the local linear expectile estimation
for a trivariate covariate setting.
}
\references{
{

Adam, C. and Gijbels, I. (2021b). Partially linear expectile regression using
local polynomial fitting. In Advances in Contemporary Statistics and Econometrics:
Festschrift in Honor of Christine Thomas-Agnan, Chapter 8, pages 139–160. Springer, New York.

}
}
