% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_GenROT_without.R
\name{h_GenROT_without}
\alias{h_GenROT_without}
\alias{compDerEstError_exp}
\title{Rule-of-Thumb bandwidth selectors in a location-scale setting
without using the one-to-one mapping}
\usage{
h_GenROT_without(X, Y, j = 0, p = 1, kernel = gaussK, omega)

compDerEstError_exp(X, Y, p, omega)
}
\arguments{
\item{X}{The covariate data values.}

\item{Y}{The response data values.}

\item{j}{The order of derivative to estimate. In default setting, \code{j=0}.}

\item{p}{The order of the local polynomial estimator. In default setting,
\code{p=1}.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}
}
\value{
\code{\link{h_GenROT_without}} provides
the Rule-of-Thumb bandwidth selector in a location-scale setting without
using the one-to-one mapping for univariate expectile regression
proposed by Adam and Gijbels (2021a).

\code{\link{compDerEstError_exp}} returns a data frame whose components are:
\itemize{
\item \code{X} The covariate data values.
\item \code{Y} The response data values.
\item \code{fit} The fitted values for the parametric estimation.
\item \code{der} The derivative estimation at \eqn{X} values.
\item \code{err} The estimation of the error vector
\item \code{err_fit} The \eqn{\omega}th expectile of the residuals
 }
}
\description{
Rule-of-Thumb bandwidth selector for the expectile regression
in a location scale without using the one-to-one mapping. The weight function
is chosen to be equal to the indicator function on \eqn{[min(X_i)+0.1,max(X_i)-0.1]}.
}
\examples{
library(locpol)
data(mcycle)
y=mcycle$accel
x=mcycle$times

h=h_GenROT_without(X=x,Y=y,j=0,p=1,kernel=gaussK,omega=0.3)
#h=1.937706

}
\references{
{

Adam, C. and Gijbels, I. (2021a). Local polynomial expectile regression.
Annals of the Institute of Statistical Mathematics doi:10.1007/s10463-021-00799-y.

}
}
