% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetracks.R
\name{genetracks}
\alias{genetracks}
\title{Plot gene tracks}
\usage{
genetracks(
  locus,
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  border = FALSE,
  cex.axis = 0.9,
  cex.lab = 1,
  cex.text = 0.7,
  gene_col = ifelse(showExons, "blue4", "skyblue"),
  exon_col = "blue4",
  exon_border = "blue4",
  showExons = TRUE,
  maxrows = NULL,
  text_pos = "top",
  xticks = TRUE,
  xlab = NULL,
  align = TRUE
)
}
\arguments{
\item{locus}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{border}{Logical whether a bounding box is plotted.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{cex.lab}{Specifies font size for axis titles.}

\item{cex.text}{Font size for gene text.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons (or genes if
\code{showExons} is \code{FALSE}). Set to \code{NA} for no border.}

\item{showExons}{Logical whether to show exons or simply show whole gene as a
rectangle. If \code{showExons = FALSE} colours are specified by \code{exon_border}
for rectangle border and \code{gene_col} for the fill colour.}

\item{maxrows}{Specifies maximum number of rows to display in gene
annotation panel.}

\item{text_pos}{Character value of either 'top' or 'left' specifying
placement of gene name labels.}

\item{xticks}{Logical whether x axis ticks and numbers are plotted.}

\item{xlab}{Title for x axis. Defaults to chromosome \code{seqname} specified
in \code{locus}.}

\item{align}{Logical whether to set \code{\link[=par]{par()}} to align the plot.}
}
\value{
No return value.
}
\description{
Plot gene annotation tracks from \code{ensembldb} data.
}
\details{
This function is called by \code{\link[=locus_plot]{locus_plot()}}. It can be used to plot
the gene annotation tracks on their own. It uses base graphics, so
\code{\link[=layout]{layout()}} can be used to position adjacent plots above or below.
}
\examples{
library(EnsDb.Hsapiens.v75)
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'UBE2L3', flank = 1e5,
             ens_db = "EnsDb.Hsapiens.v75")
genetracks(loc)

## Limit the number of tracks
genetracks(loc, maxrows = 4)

## Filter by gene biotype
genetracks(loc, filter_gene_biotype = 'protein_coding')

## Customise colours
genetracks(loc, gene_col = 'grey', exon_col = 'orange',
           exon_border = 'darkgrey')

}
