% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetrack_ly.R
\name{genetrack_ly}
\alias{genetrack_ly}
\title{Gene tracks using 'plotly'}
\usage{
genetrack_ly(
  locus,
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  cex.text = 0.7,
  gene_col = "blue4",
  exon_col = "blue4",
  exon_border = "blue4",
  maxrows = 8,
  xlab = NULL
)
}
\arguments{
\item{locus}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{cex.text}{Font size for gene text.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons. Set to \code{NA} for no
border.}

\item{maxrows}{Specifies maximum number of rows to display in gene
annotation panel.}

\item{xlab}{Title for x axis. Defaults to chromosome \code{seqname} specified
in \code{locus}.}
}
\value{
A 'plotly' plotting object showing gene tracks.
}
\description{
Plot gene annotation tracks from \code{ensembldb} data using \code{plotly}.
}
\details{
This function can used to plot gene annotation tracks on their own.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
library(EnsDb.Hsapiens.v75)
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'UBE2L3', flank = 1e5,
             ens_db = "EnsDb.Hsapiens.v75")
genetrack_ly(loc)
}
}
