% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus_plotly.R
\name{locus_plotly}
\alias{locus_plotly}
\title{Locus plotly}
\usage{
locus_plotly(
  loc,
  heights = c(0.6, 0.4),
  filter_gene_name = NULL,
  filter_gene_biotype = NULL,
  cex.text = 0.7,
  gene_col = "blue4",
  exon_col = "blue4",
  exon_border = "blue4",
  maxrows = 8,
  xlab = NULL,
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \code{\link[=locus]{locus()}}.}

\item{heights}{Vector controlling relative height of each panel on 0-1 scale.}

\item{filter_gene_name}{Vector of gene names to display.}

\item{filter_gene_biotype}{Vector of gene biotypes to be filtered. Use
\code{\link[ensembldb:EnsDb-class]{ensembldb::listGenebiotypes()}} to display possible biotypes. For example,
\code{ensembldb::listGenebiotypes(EnsDb.Hsapiens.v75)}}

\item{cex.text}{Font size for gene text.}

\item{gene_col}{Colour for gene lines.}

\item{exon_col}{Fill colour for exons.}

\item{exon_border}{Border line colour outlining exons. Set to \code{NA} for no
border.}

\item{maxrows}{Specifies maximum number of rows to display in gene
annotation panel.}

\item{xlab}{Title for x axis. Defaults to chromosome \code{seqname} specified
in \code{locus}.}

\item{...}{Optional arguments passed to \code{\link[=scatter_plotly]{scatter_plotly()}} to control the
scatter plot.}
}
\value{
A 'plotly' plotting object showing a scatter plot above gene tracks.
}
\description{
Genomic locus plot similar to locuszoom, using plotly.
}
\details{
This is an R/plotly version of locuszoom for exploring regional Manhattan
plots of gene loci. Use \code{\link[=locus]{locus()}} first to generate an object of class
'locus' for plotting. This references a selected Ensembl database for
annotating genes and exons. Hover over the points or gene tracks to reveal
more information.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = "IRF5", flank = c(7e4, 2e5), LD = "r2",
             ens_db = "EnsDb.Hsapiens.v75")
locus_plotly(loc)
}
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=genetrack_ly]{genetrack_ly()}} \code{\link[=scatter_plotly]{scatter_plotly()}}
}
