% Generated by roxygen2 (4.0.2): do not edit by hand
\name{levellog}
\alias{debug}
\alias{error}
\alias{fatal}
\alias{info}
\alias{levellog}
\alias{warn}
\title{Write messages to logs at a given priority level.}
\usage{
levellog(logger, level, message)

debug(logger, message)

info(logger, message)

warn(logger, message)

error(logger, message)

fatal(logger, message)
}
\arguments{
\item{logger}{An object of class 'logger'.}

\item{level}{The desired priority level: a number, a character, or an object
of class 'loglevel'.  Will be coerced using \code{\link{as.loglevel}}.}

\item{message}{A string to be printed to the log with the corresponding priority level.}
}
\description{
Write messages to logs at a given priority level.
}
\examples{
library('log4r')

logger <- create.logger(logfile = 'debugging.log', level = "WARN")

levellog(logger, 'WARN', 'First warning from our code')
debug(logger, 'Debugging our code')
info(logger, 'Information about our code')
warn(logger, 'Another warning from our code')
error(logger, 'An error from our code')
fatal(logger, 'I\\'m outta here')
}
\seealso{
\code{\link{loglevel}}
}

