% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loggit.R
\name{loggit}
\alias{loggit}
\title{Log entries to file}
\usage{
loggit(
  log_lvl,
  log_msg,
  ...,
  echo = TRUE,
  custom_log_lvl = FALSE,
  sanitizer = default_ndjson_sanitizer
)
}
\arguments{
\item{log_lvl}{Log level coerceable to \code{character}. For details see parameter \code{custom_log_lvl}.}

\item{log_msg}{Main log message. Will be coerced to class \code{character}.}

\item{...}{Named arguments, each a atomic vector of length one, you wish to log.
The names of the arguments are treated as column names in the log.}

\item{echo}{Should the log file entry be printed to the console as well?
Defaults to \code{TRUE}.}

\item{custom_log_lvl}{Allow log levels other than "DEBUG", "INFO", "WARN",
and "ERROR"? Defaults to \code{FALSE}.}

\item{sanitizer}{\link[=sanitizers]{Sanitizer function} to run over elements in log data.
Defaults to \code{\link[=default_ndjson_sanitizer]{default_ndjson_sanitizer()}}.}
}
\value{
Invisible \code{NULL}.
}
\description{
Log entries to a \href{https://github.com/ndjson}{ndjson} log file, defined by \code{\link[=set_logfile]{set_logfile()}}.
}
\examples{
  loggit("INFO", "This is a message", but_maybe = "you want more fields?",
  sure = "why not?", like = 2, or = 10, what = "ever")

}
