% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{bestBoostingIter}
\alias{bestBoostingIter}
\title{Get the best number of boosting iterations}
\usage{
bestBoostingIter(model, X, y, Z = NULL, consec.iter = 5, scoring_rule = "auc")
}
\arguments{
\item{model}{Fitted \code{logic.boosted} model}

\item{X}{Matrix or data frame of binary validation input data.
This object should correspond to the binary matrix for fitting the model.}

\item{y}{Validation response vector. 0-1 coding for binary outcomes.}

\item{Z}{Optional quantitative covariables supplied as a matrix or
data frame. Only used (and required) if the model was fitted using them.}

\item{consec.iter}{Number of consecutive boosting iterations that do not
increase the validation performance for determining the ideal number of
iterations}

\item{scoring_rule}{Scoring rule computing the validation performance.
This can either be \code{"auc"} for the area under the receiver
operating characteristic curve (default for binary reponses),
\code{"deviance"} for the deviance, "nce" for the normalized cross entropy
or \code{"brier"} for the Brier score.
For regression purposes, the MSE (mean squared error) is
automatically chosen.}
}
\value{
The ideal number of boosting iterations
}
\description{
This function can be used to compute the ideal number of boosting iterations
for the fitted \code{logic.boosted} model using independent validation data.
}
\details{
If the model performance (on the validation data) cannot be increased for
\code{consec.iter} consecutive boosting iterations, the last iteration
which increased the validation performance induces the ideal number of
boosting iterations.
}
