% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxe.test.R
\name{gxe.test}
\alias{gxe.test}
\title{Gene-environment interaction test}
\usage{
gxe.test(model, X, y, Z, perm.test = TRUE, n.perm = 10000)
}
\arguments{
\item{model}{A fitted \code{logicDT} model with 4pL models in its leaves.}

\item{X}{Binary predictor data for testing the interaction effect.
This can be equal to the training data.}

\item{y}{Response vector for testing the interaction effect.
This can be equal to the training data.}

\item{Z}{Quantitative covariable for testing the interaction effect.
This can be equal to the training data.}

\item{perm.test}{Should additionally permutation testing be performed?
Useful if likelihood ratio test asymptotics cannot be justified.}

\item{n.perm}{Number of random permutations for permutation testing}
}
\value{
A list containing
  \item{\code{p.chisq}}{The p-value of the chi-squared test statistic.}
  \item{\code{p.f}}{The p-value of the F test statistic.}
  \item{\code{p.perm}}{The p-value of the optional permutation test.}
  \item{\code{ll.shared}}{Log likelihood of the shared parameters 4pL model.}
  \item{\code{ll.full}}{Log likelihood of the full \code{logicDT} model.}
  \item{\code{rss.shared}}{Residual sum of squares of the shared parameters
    4pL model.}
  \item{\code{rss.full}}{Residual sum of squares of the full \code{logicDT}
    model.}
}
\description{
Using a fitted \code{logicDT} model, a general GxE interaction
test can be performed.
}
\details{
The testing is done by fitting one shared 4pL model
for all tree branches with different offsets, i.e., allowing main effects
of SNPs. This shared model is compared to the individual 4pL models fitted
in the \code{\link{logicDT}} procedure using a likelihood ratio test which
is asymptotically \eqn{\chi^2} distributed. The degrees of freedom are
equal to the difference in model parameters.
For regression tasks, alternatively, a F-test can be utilized.

The shared 4pL model is given by
\deqn{Y = \tilde{f}(x, z, b, c, d, e, \beta_1, \ldots, \beta_{G-1})
  + \varepsilon = c + \frac{d-c}{1+\exp(b \cdot (x-e))}
  + \sum_{g=1}^{G-1} \beta_g \cdot 1(z = g) + \varepsilon}
with \eqn{z \in \lbrace 1, \ldots, G \rbrace} being a grouping variable,
\eqn{\beta_1, \ldots, \beta_{G-1}} being the offsets for the different
groups, and \eqn{\varepsilon} being a random error term.
Note that the last group \eqn{G} does not have an offset parameter, since
the model is calibrated such that the curve without any \eqn{\beta}'s
fits to the last group.

The likelihood ratio test statistic is given by
\deqn{\Lambda = -2(\ell_{\mathrm{shared}} - \ell_{\mathrm{full}})}
for the log likelihoods of the shared and full 4pL models, respectively.
In the regression case, the test statistic can be calculated as
\deqn{\Lambda = N(\log(\mathrm{RSS}_{\mathrm{shared}}) -
  \log(\mathrm{RSS}_{\mathrm{full}}))}
with \eqn{\mathrm{RSS}} being the residual sum of squares for the
respective model.

For regression tasks, the alternative F test statistic is given by
\deqn{f = \frac{\frac{1}{\mathrm{df}_1}(\mathrm{RSS}_{\mathrm{shared}} -
  \mathrm{RSS}_{\mathrm{full}})}
  {\frac{1}{\mathrm{df}_2} \mathrm{RSS}_{\mathrm{full}}}}
with
\deqn{\mathrm{df}_1 = \mathrm{Difference\ in\ the\ number\ of\ model\
parameters} = 3 \cdot n_{\mathrm{scenarios}} - 3,}
\deqn{\mathrm{df}_2 = \mathrm{Degrees\ of\ freedom\ of\ the\ full\ model}
= N - 4 \cdot n_{\mathrm{scenarios}},}
and \eqn{n_{\mathrm{scenarios}}} being the number of identified predictor
scenarios/groups by \code{\link{logicDT}}.

Alternatively, if linear models were fitted in the supplied \code{logicDT}
model, shared linear models can be used to test for a GxE interaction.
For continuous outcomes, the shared linear model is given by
\deqn{Y = \tilde{f}(x, z, \alpha, \beta_1, \ldots, \beta_{G})
  + \varepsilon = \alpha \cdot x
  + \sum_{g=1}^{G} \beta_g \cdot 1(z = g) + \varepsilon.}
For binary outcomes, LDA (linear discriminant analysis) models are fitted.
In contrast to the 4pL-based test for binary outcomes, varying offsets for
the individual groups are injected to the linear predictor instead of to
the probability (response) scale.

If only few samples are available and the asymptotics of likelihood ratio
tests cannot be justified, alternatively, a permutation test approach
can be employed by setting \code{perm.test = TRUE} and specifying an
appropriate number of random permutations via \code{n.perm}.
For this approach, computed likelihoods of the shared and (paired) full
likelihood groups are randomly interchanged approximating the null
distribution of equal likelihoods. A p-value can be computed by determining
the fraction of more extreme null samples compared to the original
likelihood ratio test statistic, i.e., using the fraction of higher
likelihood ratios in the null distribution than the original likelihood
ratio.
}
