% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{coef.logitr}
\alias{coef.logitr}
\title{Get the model coefficients}
\usage{
\method{coef}{logitr}(object, ...)
}
\arguments{
\item{object}{The output of a model estimated using the \code{logitr()} function.}

\item{...}{other arguments}
}
\value{
A vector of the coefficients from a model estimated using the
\code{logitr()} function.
}
\description{
Returns the coefficients of an estimated model of the 'logitr' class.
}
\examples{
# Run a MNL model in the Preference Space:
data(yogurt)

mnl_pref <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("price", "feat", "dannon", "hiland", "yoplait")
)

# Get the model coefficients:
coef(mnl_pref)
}
\keyword{coef}
\keyword{logitr}
