% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.logitr}
\alias{summary.logitr}
\title{View summary of estimated model}
\usage{
\method{summary}{logitr}(object, ...)
}
\arguments{
\item{object}{The output of a model estimated model using the \code{logitr()}
function.}

\item{...}{other arguments}
}
\value{
No return value; prints a summary of the model results to the
console.
}
\description{
Prints a summary of a model estimated using the \code{logitr()} function
}
\examples{
# Run a MNL model in the Preference Space with a multistart:
data(yogurt)

mnl_pref <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("price", "feat", "dannon", "hiland", "yoplait"),
  options = list(
    numMultiStarts = 5,
    keepAllRuns = TRUE
  )
)

# View a summary of the model:
summary(mnl_pref)
}
\keyword{logitr}
\keyword{logitr.multistart}
\keyword{summary}
