% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdp.R
\name{lol.project.mdp}
\alias{lol.project.mdp}
\title{Maximal Data  Piling}
\usage{
lol.project.mdp(X, Y, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the samples with \code{K} unique labels.}

\item{...}{optional args.}
}
\value{
A list of class \code{embedding} containing the following:
\item{A}{\code{[d, K-1]} the projection matrix from \code{d} to \code{K-1} dimensions.}
\item{ylabs}{\code{[K]} vector containing the \code{K} unique, ordered class labels.}
\item{centroids}{\code{[K, d]} centroid matrix of the \code{K} unique, ordered classes in native \code{d} dimensions.}
\item{priors}{\code{[K]} vector containing the \code{K} prior probabilities for the unique, ordered classes.}
\item{Xr}{\code{[n, K-1]} the \code{n} data points in reduced dimensionality \code{K-1}.}
\item{cr}{\code{[K, K-1]} the \code{K} centroids in reduced dimensionality \code{K-1}.}
}
\description{
A function for implementing the Maximal Data Piling (MDP) Algorithm.
}
\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.mdp(X=X, Y=Y)  # use mdp to project into maximal data piling
}
\author{
Minh Tang and Eric Bridgeford
}
