% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_classifier.R
\name{lol.classify.randomGuess}
\alias{lol.classify.randomGuess}
\title{Randomly Guessing Classifier Training}
\usage{
lol.classify.randomGuess(X, Y, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the \code{n} samples.}

\item{...}{optional args.}
}
\value{
A list of class \code{randomGuess}, with the following attributes:
\item{ylabs}{\code{[K]} the ylabels for each of the \code{K} unique classes, ordered.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
}
\description{
A function that trains a classifier based on random guessing.
}
\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.classify.randomGuess(X, Y)
}
\author{
Eric Bridgeford
}
