% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshstab.R
\name{conf_interv}
\alias{conf_interv}
\title{Confidence intervals for profile likelihoods}
\usage{
conf_interv(
  object,
  level = 0.95,
  prob = c((1 - level)/2, 1 - (1 - level)/2),
  print = FALSE,
  ...
)
}
\arguments{
\item{object}{a list containing information about the profile likelihood in the same format as the \code{hoa} package}

\item{level}{probability level of the confidence interval}

\item{prob}{vector of length 2 containing the bounds, by default double-sided}

\item{print}{logical indicating whether the intervals are printed to the console}

\item{...}{additional arguments passed to the function}
}
\value{
a table with confidence intervals.
}
\description{
This code is adapted from the \code{mev} package.
}
\keyword{internal}
