% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vgislw.R
\name{vgislw}
\alias{vgislw}
\title{VGIS: Very good importance sampling}
\usage{
vgislw(lw, wcp = 0.2, thresh = 100, kmax = 2, wtrunc = 3/4,
  cores = parallel::detectCores())
}
\arguments{
\item{lw}{a matrix or vector of log weights. For for computing LOO \code{lw =
-log_lik} (see \code{\link{extract_log_lik}}) and is an \eqn{S} by \eqn{N}
matrix where \eqn{S} is the number of simulations and \eqn{N} is the number
of data points. (If \code{lw} is a vector it will be coerced to a
one-column matrix.)}

\item{wcp}{the proportion of importance weights to use for the generalized
Pareto fit. The \code{100*wcp}\% largest weights are used as the sample
from which to estimate the parameters of the generalized Pareto
distribution.}

\item{thresh}{when used for the generalized pareto fit, the largest
\code{100*wcp}\% of the importance weights are modified according to
\code{pmax(x, max(x) - thresh)} for numerical stability.}

\item{kmax}{maximum allowed value for the generalized Pareto shape parameter
\eqn{k}.}

\item{wtrunc}{for truncating very large weights to \eqn{S}^\code{wtrunc}. Set
to zero for no truncation.}

\item{cores}{the number of cores to use for parallelization.}
}
\value{
A named with list with components \code{lw_smooth} (modified log
  weights) and \code{pareto_k} (estimated generalized Pareto shape parameters
  \eqn{k}).
}
\description{
VGIS: Very good importance sampling
}
\details{
See the 'VGIS-LOO' section in \code{\link{loo-package}}.
}
\note{
This function is primarily intended for internal use, but is exported
  so that users can call it directly for other purposes. Users simply
  wishing to compute LOO and WAIC should use the \code{\link{loo_and_waic}}
  function.
}
\seealso{
\code{\link{loo-package}}, \code{\link{loo_and_waic}}
}

