% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_k.R
\name{pareto-k-diagnostic}
\alias{pareto-k-diagnostic}
\alias{pareto_k_ids}
\alias{pareto_k_table}
\alias{plot.loo}
\title{Diagnostics for Pareto Smoothed Importance Sampling}
\usage{
pareto_k_table(x)

pareto_k_ids(x, threshold = 0.5)

\method{plot}{loo}(x, ..., label_points = FALSE)
}
\arguments{
\item{x}{For \code{pareto_k_ids} and \code{pareto_k_table}, an object created
by \code{\link{loo}} or \code{\link{psislw}}. For \code{plot}, an object
created by \code{\link{loo}}.}

\item{threshold}{The threshold value for \eqn{k}.}

\item{label_points, ...}{For the \code{plot} method, if \code{label_points} is
\code{TRUE} the observation numbers corresponding to any values of \eqn{k}
greater than 0.5 will be displayed in the plot. Any arguments specified in
\code{...} will be passed to \code{\link[graphics]{text}} and can be used
to control the appearance of the labels.}
}
\value{
\code{pareto_k_table} returns an object of class
  \code{"pareto_k_table"}, which is a matrix with columns \code{"Count"} and
  \code{"Proportion"} and has its own print method.

\code{pareto_k_ids} returns an integer vector indicating which
observations have Pareto \eqn{k} estimates above \code{threshold}.

The \code{plot} method is called for its side effect and does not
  return anything. If \code{x} is the result of a call to \code{\link{loo}},
  \code{plot(x)} produces a plot of the estimates of the Pareto shape
  parameter \eqn{k}. There is no \code{plot} method for objects generated by
  a call to \code{\link{waic}}.
}
\description{
Print a diagnostic table summarizing the estimated Pareto shape parameters,
find the indexes of observations for which the estimated Pareto shape
parameter \eqn{k} is larger than some \code{threshold} value, or plot
observation indexes vs \eqn{k} estimates.
}
\details{
The reliability of PSIS estimates can be assessed using the
  estimates of the shape parameter \eqn{k} of the generalized Pareto
  distribution. See \code{\link{loo-package}} for background on the PSIS
  procedure. Here we focus on the interpretation of \eqn{k}:

  \itemize{
  \item If \eqn{k < 1/2} the variance of the raw importance ratios
  is finite, the central limit theorem holds, and the estimate converges
  quickly.

  \item If \eqn{k} is between 1/2 and 1 the variance of the raw importance
  ratios is infinite but the mean exists, the generalized central limit
  theorem for stable distributions holds, and the convergence of the estimate
  is slower. The variance of the PSIS estimate is finite but may be large.

  \item If \eqn{k > 1} the variance and the mean of the raw ratios
  distribution do not exist. The variance of the PSIS estimate is finite but
  may be large.
  }

  If the estimated tail shape parameter \eqn{k} exceeds \eqn{0.5}, the user
  should be warned, although in practice we have observed good performance
  for values of \eqn{k} up to 0.7. Even if the PSIS estimate has a finite
  variance, the user should consider sampling directly from \eqn{p(\theta^s |
  y_{-i})} for the problematic \eqn{i}, use \eqn{k}-fold cross-validation, or
  use a more robust model. Importance sampling is likely to work less well if
  the marginal posterior \eqn{p(\theta^s | y)} and LOO posterior
  \eqn{p(\theta^s | y_{-i})} are much different, which is more likely to
  happen with a non-robust model and highly influential observations. A
  robust model may reduce the sensitivity to highly influential observations.
}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2016a). Practical
  Bayesian model evaluation using leave-one-out cross-validation and WAIC.
  \emph{Statistics and Computing}. Advance online publication.
  doi:10.1007/s11222-016-9696-4. arXiv preprint:
  \url{http://arxiv.org/abs/1507.04544/}

Vehtari, A., Gelman, A., and Gabry, J. (2016b). Pareto smoothed
  importance sampling. arXiv preprint: \url{http://arxiv.org/abs/1507.02646/}
}
\seealso{
\code{\link{loo-package}}.
}

