% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psis_approximate_posterior.R
\name{ap_psis}
\alias{ap_psis}
\alias{ap_psis.array}
\alias{ap_psis.matrix}
\alias{ap_psis.default}
\title{Pareto smoothed importance sampling (PSIS)
using approximate posteriors}
\usage{
ap_psis(log_ratios, log_p, log_g, ...)

\method{ap_psis}{array}(log_ratios, log_p, log_g, ..., cores = getOption("mc.cores", 1))

\method{ap_psis}{matrix}(log_ratios, log_p, log_g, ..., cores = getOption("mc.cores", 1))

\method{ap_psis}{default}(log_ratios, log_p, log_g, ...)
}
\arguments{
\item{log_ratios}{The log-likelihood ratios (ie -log_liks)}

\item{log_p}{The log-posterior (target) evaluated at S samples from the
proposal distribution (g). A vector of length S.}

\item{log_g}{The log-density (proposal) evaluated at S samples from the
proposal distribution (g). A vector of length S.}

\item{...}{Currently not in use.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}
}
\description{
Pareto smoothed importance sampling (PSIS)
using approximate posteriors
}
\section{Methods (by class)}{
\itemize{
\item \code{ap_psis(array)}: An \eqn{I} by \eqn{C} by \eqn{N} array, where \eqn{I}
is the number of MCMC iterations per chain, \eqn{C} is the number of
chains, and \eqn{N} is the number of data points.

\item \code{ap_psis(matrix)}: An \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size
of the posterior sample (with all chains merged) and \eqn{N} is the number
of data points.

\item \code{ap_psis(default)}: A vector of length \eqn{S} (posterior sample size).

}}
