% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{selection}
\alias{selection}
\title{Modify the \code{selected} component}
\usage{
selection(selected = NULL, selectBy = NULL, selectionLogic = NULL)
}
\arguments{
\item{selected}{A logical vector. If it is set as \code{TRUE}, the elements are highlighted
as the graphics are constructed. Default is \code{FALSE}}

\item{selectBy}{Select by "sweeping" (default) or "brushing".}

\item{selectionLogic}{Selection logic. One of "select" (default), "deselect" and "invert". See details.}
}
\value{
a \code{ggproto} object
}
\description{
In interactive graphics, \code{selection} is one of the most fundamental tool
and used to highlight the subset of interest
}
\details{
There are two ways to directly select elements on the scatterplot using the mouse:
either by "sweep" or by "brushing". "Sweeping" allows us to sweep out a contiguous area of the plot,
while, in "brushing", the area is always fixed during the selection.

The selection logic give users more flexibility that users cannot only highlight the elements,
but also can delight or invert (the highlighted to delighted, vice verse) the elements.
}
\examples{
if(interactive()) {

  # highlight the four gear cars
  fourGear <- rep(FALSE, nrow(mtcars))
  fourGear[mtcars$gear == 4] <- TRUE

  l_ggplot(mtcars, mapping = aes(x = wt, y = hp, color = factor(cyl))) +
    geom_point(size = 4) +
    # push the states of scatter plot to the histogram
    selection(selected = fourGear)
}
}
\seealso{
\code{\link{active}}, \code{\link{linking}}, \code{\link{zoom}},
\code{\link{hover}}, \code{\link{interactivity}}
}
