% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.loon.R
\name{shiny.loon}
\alias{shiny.loon}
\title{Automatically Create a \code{shiny} App Based on Interactive \code{Loon} Widgets}
\usage{
shiny.loon(
  widgets,
  showWorldView = TRUE,
  plotWidth = "500px",
  plotHeight = "500px",
  selectBy = c("byDefault", "brushing", "sweeping"),
  layout_matrix,
  nrow = NULL,
  ncol = NULL,
  colorList = loon::l_getColorList(),
  top = 60,
  left = "auto",
  right = 20,
  bottom = "auto",
  inspectorWidth = 350,
  inspectorHeight = "auto",
  options = list(),
  arrangeGrobArgs = list(),
  ...
)
}
\arguments{
\item{widgets}{a \code{loon} widget or a list of \code{loon} widgets.}

\item{showWorldView}{logical; whether to show the world view.}

\item{plotWidth}{Image width, same with \code{height}.}

\item{plotHeight}{Image height. Must be a valid \code{CSS} unit (like '100%', '400px') or a number, 
which will be coerced to a string and have 'px' appended. More details, see \code{\link{plotOutput}}.}

\item{selectBy}{The way to brush, can be 'brushing' (keep the brush whenever the plot is updated), 
'sweeping' (clear the brush whenever the plot is updated) or 'byDefault' (determined by \code{loon} widget 'selectBy', 
if 'selectBy' is sweeping, then \code{selectBy} will be assigned to 'sweeping', vice versa)}

\item{layout_matrix}{Optional layout matrix to place \code{loon} widgets, see \code{\link{grid.arrange}}.}

\item{nrow}{Number of rows, see \code{\link{grid.arrange}}.}

\item{ncol}{Number of columns, see \code{\link{grid.arrange}}.}

\item{colorList}{A list of colors displayed on modify panel.}

\item{top}{Distance between the top of the inspector panel, and the top of the page or parent container.}

\item{left}{Distance between the left side of the inspector panel, and the left of the page or parent container.}

\item{right}{Distance between the right side of the inspector panel, and the right of the page or parent container.}

\item{bottom}{Distance between the bottom of the inspector panel, and the bottom of the page or parent container.}

\item{inspectorWidth}{Width of the inspector panel.}

\item{inspectorHeight}{Height of the inspector panel.}

\item{options}{\code{shinyApp} argument that should be passed to the \code{runApp} call, see \code{\link{shinyApp}}.}

\item{arrangeGrobArgs}{Other \code{arrangeGrob} arguments to place the \code{loon} widgets, see \code{\link{grid.arrange}}.}

\item{...}{Named arguments to modify shiny app.}
}
\value{
A \code{shiny.appobj} object that represents the \code{loon.shiny} app. 
Printing the object or passing it to \code{\link{runApp}} will run the app.
}
\description{
Interactive \code{loon} widgets displayed in \code{shiny} app
}
\details{
Useful hints:
\itemize{
 \item{}{The effect of any \code{actionButton}s can be terminated by a simple click on canvas.}
 \item{}{The choices of 'select_by_color' can be updated by double click on color 'apply' \code{actionButton}.}
}
}
\examples{
## Only run this example in interactive R sessions
if(interactive()) {
  ############### Basic ###############
  p <- l_plot(iris, 
              color = iris$Species, 
              showGuides = TRUE, 
              showScales = TRUE)

  shiny.loon(p)
  
  ############### Link multiple plots ###############
  p1 <- l_plot(iris,
               linkingGroup = 'iris', 
               showLabels = FALSE)
  p2 <- l_hist(iris$Sepal.Length, 
               linkingGroup = 'iris', 
               showLabels = FALSE, 
               showStackedColors = TRUE)
  p3 <- l_hist(iris$Sepal.Width, linkingGroup = 'iris', 
               color = iris$Species, sync = 'push',
               showLabels = FALSE, swapAxes = TRUE, 
               showStackedColors = TRUE)
  shiny.loon(list(p1, p2, p3), 
             layout_matrix = matrix(c(2,NA,1,3), 
             nrow = 2, byrow = TRUE))
}

\dontrun{
  if (requireNamespace('loon.ggplot', quietly = TRUE)) {
      p <- ggplot(mpg, aes(displ, hwy)) +
        geom_point(data = transform(mpg, class = NULL), colour = 'grey85') +
        geom_point() +
        facet_wrap(~class)
      g <- loon.ggplot(p, activeGeomLayers = 2) # active the second layer
      shiny.loon(g)
  }
}
}
