% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_move}
\alias{l_layer_move}
\title{Move a layer}
\usage{
l_layer_move(widget, layer, parent, index = "0")
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}

\item{parent}{if parent layer is not specified it is set to the current
parent layer of the layer}

\item{index}{position among its siblings. valid values are 0, 1, 2, ...,
'end'}
}
\value{
0 if success otherwise the function throws an error
}
\description{
The postition of a layer in the layer tree determines the 
  rendering order. That is, the non-group layers are rendered in order of a 
  Depth-first traversal of the layer tree. The toplevel group layer is called
  \code{'root'}.
}
\examples{
p <- l_plot()

l <- l_layer_rectangle(p, x=0:1, y=0:1, color="steelblue")
g <- l_layer_group(p)
l_layer_printTree(p)

l_layer_move(l, parent=g)
l_layer_printTree(p)

l_layer_move(p, 'model', parent=g)
l_layer_printTree(p)
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_printTree}},
  \code{\link{l_layer_index}}
}
