% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot.R
\name{l_plot.default}
\alias{l_plot.default}
\title{Create an interactive 2d scatterplot display}
\usage{
\method{l_plot}{default}(x, y = NULL, parent = NULL, ...)
}
\arguments{
\item{x}{the \code{x} and \code{y} arguments provide the x and y
    coordinates for the plot.  Any reasonable way of defining the
    coordinates is acceptable.  See the function \code{\link{xy.coords}}
    for details.  If supplied separately, they must be of the same length.}

\item{y}{please read in the argument description for the \code{x} argument above.}

\item{parent}{a valid Tk parent widget path. When the parent widget is
specified (i.e. not \code{NULL}) then the plot widget needs to be placed using
some geometry manager like \code{\link{tkpack}} or \code{\link{tkplace}} in
order to be displayed. See the examples below.}

\item{...}{named arguments to modify plot states.}
}
\description{
Creates an interactive 2d scatterplot. Also, if no loon
  inspector is open then the \code{l_plot} call will also open a loon
  inspector.
}
\details{
The scatterplot displays a number of direct interactions with the
  mouse and keyboard, these include: zooming towards the mouse cursor using
  the mouse wheel, panning by right-click dragging and various selection
  methods using the left mouse button such as sweeping, brushing and
  individual point selection. See the documentation for \code{\link{l_plot}}
  for more details about the interaction gestures.
}
\examples{

# default use as scatterplot

p1 <- with(iris, l_plot(Sepal.Length, Sepal.Width, color=Species))

p2 <- with(iris, l_plot(Petal.Length ~ Petal.Width, color=Species))

# link the two plots p1 and p2
l_configure(p1, linkingGroup="iris", sync="push")
l_configure(p2, linkingGroup="iris", sync="push")
p1['selected'] <- iris$Species == "setosa"

}
