% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_make_glyphs.R
\name{l_make_glyphs}
\alias{l_make_glyphs}
\title{Make arbitrary glyphs with R graphic devices}
\usage{
l_make_glyphs(data, draw_fun, width = 50, height = 50, ...)
}
\arguments{
\item{data}{list where each element contains a data object used for the
\code{draw_fun}}

\item{draw_fun}{function that draws a glyph using \R base graphics or the
grid (including ggplot2 and lattice) engine}

\item{width}{width of each glyph in pixel}

\item{height}{height of each glyph in pixel}

\item{...}{additional arguments passed on to the \code{\link{png}} function}
}
\value{
vector with tk img object references
}
\description{
Loon's primitive glyph types are limited in terms of compound
  shapes. With this function you can create each point glyph as a png and
  re-import it as a tk img object to be used as point glyphs in loon. See the
  examples.
}
\examples{
if(interactive()){

\dontrun{
if (requireNamespace("maps", quietly = TRUE)) {
  data(minority)
  p <- l_plot(minority$long, minority$lat)

  canada <- maps::map("world",  "Canada", fill=TRUE, plot=FALSE)
  l_map <- l_layer(p, canada, asSingleLayer=TRUE)
  l_scaleto_world(p)

  img <- l_make_glyphs(lapply(1:nrow(minority), function(i)minority[i,]), function(m) {
      par(mar=c(1,1,1,1)*.5)
      mat <- as.matrix(m[1,1:10]/max(m[1:10]))
      barplot(height = mat,
              beside = FALSE,
              ylim = c(0,1),
              axes= FALSE,
              axisnames=FALSE)
  }, width=120, height=120)

  l_imageviewer(img)

  g <- l_glyph_add_image(p, img, "barplot")
  p['glyph'] <- g

}

## with grid
if (requireNamespace("grid", quietly = TRUE)) {

  li <- l_make_glyphs(runif(6), function(x) {
      if(any(x>1 | x<0))
          stop("out of range")
      grid::pushViewport(grid::plotViewport(grid::unit(c(1,1,1,1)*0, "points")))
      grid::grid.rect(gp=grid::gpar(fill=NA))
      grid::grid.rect(0, 0, height = grid::unit(x, "npc"), just = c("left", "bottom"),
                gp=grid::gpar(col=NA, fill="steelblue"))
  })

  l_imageviewer(li)

  p <- l_plot(1:6)
  g <- l_glyph_add_image(p, li, "bars")
  p['glyph'] <- g
}

}
}
}
