% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_facet.R
\name{l_facet}
\alias{l_facet}
\alias{l_facet.loon}
\alias{l_facet.l_serialaxes}
\title{Layout Facets across multiple panels}
\usage{
l_facet(widget, by, on, layout = c("grid", "wrap", "separate"), ...)

\method{l_facet}{loon}(
  widget,
  by,
  on,
  layout = c("grid", "wrap", "separate"),
  connectedScales = c("cross", "row", "column", "both", "x", "y", "none"),
  linkingGroup,
  nrow = NULL,
  ncol = NULL,
  inheritLayers = TRUE,
  labelLocation = c("top", "right"),
  labelBackground = "gray80",
  labelForeground = "black",
  labelBorderwidth = 2,
  labelRelief = c("groove", "flat", "raised", "sunken", "ridge", "solid"),
  plotWidth = 200,
  plotHeight = 200,
  parent = NULL,
  ...
)

\method{l_facet}{l_serialaxes}(
  widget,
  by,
  on,
  layout = c("grid", "wrap", "separate"),
  linkingGroup,
  nrow = NULL,
  ncol = NULL,
  labelLocation = c("top", "right"),
  labelBackground = "gray80",
  labelForeground = "black",
  labelBorderwidth = 2,
  labelRelief = c("groove", "flat", "raised", "sunken", "ridge", "solid"),
  plotWidth = 200,
  plotHeight = 200,
  parent = NULL,
  ...
)
}
\arguments{
\item{widget}{A loon widget}

\item{by}{loon plot can be separated by some variables into mutiple panels.
This argument can take a \code{vector}, a \code{list} of same lengths or a \code{data.frame} as input.}

\item{on}{if the \code{by} is a formula, an optional data frame containing the variables in the \code{by}.
If variables in \code{by} is not found in data, the variables are taken from environment(formula),
typically the environment from which the function is called.}

\item{layout}{layout facets as \code{'grid'}, \code{'wrap'} or \code{'separate'}}

\item{...}{named arguments to modify the `loon` widget states}

\item{connectedScales}{Determines how the scales of the facets are to be connected depending
on which \code{layout} is used.  For each value of \code{layout}, the scales are connected
as follows:
\itemize{
\item{\code{layout = "wrap":}  Across all facets, when \code{connectedScales} is
   \itemize{
   \item{\code{"x"}, then  only the "x"  scales are connected}
   \item{\code{"y"}, then only the "y" scales are connected}
   \item{\code{"both"},  both "x" and "y" scales are connected}
   \item{\code{"none"},  neither "x" nor "y" scales are connected.}
   For any other value, only the "y" scale is connected.
   }
   }
\item{\code{layout = "grid":}  Across all facets, when \code{connectedScales} is
   \itemize{
   \item{\code{"cross"}, then only the scales in the same row and the same column are connected}
   \item{\code{"row"}, then both "x" and "y" scales of facets in the same row are connected}
   \item{\code{"column"}, then both "x" and "y" scales of facets in the same column are connected}
   \item{\code{"x"}, then all of the "x"  scales are connected (regardless of column)}
   \item{\code{"y"}, then all of the "y" scales are connected (regardless of row)}
   \item{\code{"both"},  both "x" and "y" scales are connected in all facets}
   \item{\code{"none"},  neither "x" nor "y" scales are connected in any facets.}
   }
   }
 }}

\item{linkingGroup}{A linkingGroup for widgets. If missing, default would be a paste of
"layout" and the current tk path number.}

\item{nrow}{The number of layout rows}

\item{ncol}{The number of layout columns}

\item{inheritLayers}{Logical value. Should widget layers be inherited into layout panels?}

\item{labelLocation}{Labels location.
\itemize{
\item {
Length two vector for layout \code{grid}.
The first one is used to determine the position of column labels ('top' or 'bottom').
The second one is used to determine the position of row labels ('right' or 'left').
}
\item {
Length one vector for layout \code{wrap}, 'top' or 'bottom'.
}
}}

\item{labelBackground}{Label background colour}

\item{labelForeground}{Label foreground colour}

\item{labelBorderwidth}{Label border width}

\item{labelRelief}{Label relief}

\item{plotWidth}{default plot width (in pixels)}

\item{plotHeight}{default plot height (in pixels)}

\item{parent}{a valid Tk parent widget path. When the parent widget is
specified (i.e. not \code{NULL}) then the plot widget needs to be placed using
some geometry manager like \code{\link{tkpack}} or \code{\link{tkplace}} in
order to be displayed. See the examples below.}
}
\value{
an `l_facet` object (an `l_compound` object), being a list with named elements,
each representing a separate interactive plot.
The names of the plots should be self explanatory and a list
of all plots can be accessed from the `l_facet` object via `l_getPlots()`.
}
\description{
It takes a loon widget and forms a matrix of loon widget
facets.
}
\examples{
if(interactive()) {
  library(maps)
  p <- with(quakes, l_plot(long, lat, linkingGroup = "quakes"))
  p["color"][quakes$mag < 5 & quakes$mag >= 4] <- "lightgreen"
  p["color"][quakes$mag < 6 & quakes$mag >= 5] <- "lightblue"
  p["color"][quakes$mag >= 6] <- "firebrick"
  # A Fiji map
  NZFijiMap <- map("world2", regions = c("New Zealand", "Fiji"), plot = FALSE)
  l_layer(p, NZFijiMap,
          label = "New Zealand and Fiji",
          color = "forestgreen",
          index = "end")
  fp <- l_facet(p, by = "color", layout = "grid",
                linkingGroup = "quakes")

  size <- c(rep(50, 2), rep(25, 2), rep(50, 2))
  color <- c(rep("red", 3), rep("green", 3))
  p <- l_plot(x = 1:6, y = 1:6,
              size = size,
              color = color)
  g <- l_glyph_add_text(p, text = 1:6)
  p['glyph'] <- g
  on <- data.frame(Factor1 = c(rep("A", 3), rep("B", 3)),
                   Factor2 = rep(c("C", "D"), 3))
  cbind(on, size = size, color = color)
  fp <- l_facet(p, by = Factor1 ~ Factor2, on = on)
}

if(interactive()) {

# serialaxes facets
s <- l_serialaxes(iris[, -5], color = iris$Species)
fs <- l_facet(s, layout = "wrap", by = iris$Species)
# The linkingGroup can be printed or accessed by
l_configure(s, linkingGroup = fs[[1]]['linkingGroup'], sync = "pull")
}
}
