% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bind.R
\name{l_bind_item}
\alias{l_bind_item}
\title{Create a Canvas Binding}
\usage{
l_bind_item(widget, tags, event, callback)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{tags}{item tags as as explained in
\code{l_help("learn_R_bind.html#item-bindings")}}

\item{event}{event patterns as defined for Tk canvas widget
\url{https://www.tcl.tk/man/tcl8.6/TkCmd/bind.htm#M5}.}

\item{callback}{callback function is an R function which is called by the Tcl
interpreter if the event of interest happens. Note that in loon the 
callback functions support different optional arguments depending on the
binding type, read the details for more information}
}
\value{
item binding id
}
\description{
Canvas bindings are triggered by a mouse/keyboard gesture over
  the plot as a whole.
}
\details{
Item bindings are used for evaluating callbacks at certain mouse and/or
keyboard gestures events (i.e. X events) on visual items on the canvas. Items
on the canvas can have tags and item bindings are specified to be evaluated
at certain X events for items with specific tags.

Note that item bindings get currently evaluated in the order that they are
added.

Bindings, callbacks, and binding substitutions are described in detail in
loon's documentation webpage, i.e. run \code{l_help("learn_R_bind")}
}
\seealso{
\code{\link{l_bind_item_ids}}, \code{\link{l_bind_item_get}},
  \code{\link{l_bind_item_delete}}, \code{\link{l_bind_item_reorder}}
}
