% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_promote}
\alias{l_layer_promote}
\title{Moves the layer up to be a left sibling of its parent}
\usage{
l_layer_promote(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
0 if success otherwise the function throws an error
}
\description{
Moves the layer down the layer tree (towards the root layer) if
  the parent layer is not the root layer.
}
\examples{
if(interactive()){

p <- l_plot()

g1 <- l_layer_group(p)
g2 <- l_layer_group(p, parent=g1)
l1 <- l_layer_oval(p, x=0:1, y=0:1, parent=g2)

l_layer_printTree(p)
l_layer_promote(p, l1)
l_layer_printTree(p)
l_layer_promote(p, l1)
l_layer_printTree(p)

}
}
