% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_synthetic_data.R
\name{gen.synth.xdata}
\alias{gen.synth.xdata}
\title{Generate xdata matrix with pre-determined covariance}
\usage{
gen.synth.xdata(n.obs, n.vars, rho, my.mean = rep(0, n.vars))
}
\arguments{
\item{n.obs}{number of observations}

\item{n.vars}{number of variables}

\item{rho}{value used to calculate rho^|i-j| . values between 1 and 0}

\item{my.mean}{vector of mean variables}
}
\value{
a matrix of xdata
}
\description{
Covariance matrix is created using for each position
  cov.matrix[i,j] = rho^|i-j|
}
\examples{
gen.synth.xdata(100, 8, .75)
gen.synth.xdata(1000, 5, .2)
cov(gen.synth.xdata(n.obs = 10, n.vars = 10, rho = .2))
}
