% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi.lori.R
\name{mi.lori}
\alias{mi.lori}
\title{The mi.lori performs M multiple imputations using the
lori method. Multiple imputation allows to produce estimates of missing
values, as well as intervals of variability. The classical
procedure is to perform M multiple imputations using the mi.lori
method, and to aggregate them using the pool.lori method.}
\usage{
mi.lori(
  Y,
  cov = NULL,
  lambda1 = NULL,
  lambda2 = NULL,
  M = 25,
  intercept = T,
  reff = T,
  ceff = T,
  rank.max = 5,
  algo = c("alt", "mcgd"),
  thresh = 1e-05,
  maxit = 1000,
  trace.it = F
)
}
\arguments{
\item{Y}{[matrix, data.frame] count table (nxp).}

\item{cov}{[matrix, data.frame] design matrix (np*q) in order row1xcol1,row2xcol2,..,rownxcol1,row1xcol2,row2xcol2,...,...,rownxcolp}

\item{lambda1}{[positive number] the regularization parameter for the interaction matrix.}

\item{lambda2}{[positive number] the regularization parameter for the covariate effects.}

\item{M}{[integer] the number of multiple imputations to perform}

\item{intercept}{[boolean] whether an intercept should be fitted, default value is FALSE}

\item{reff}{[boolean] whether row effects should be fitted, default value is TRUE}

\item{ceff}{[boolean] whether column effects should be fitted, default value is TRUE}

\item{rank.max}{[integer] maximum rank of interaction matrix (smaller than min(n-1,p-1))}

\item{algo}{type of algorithm to use, either one of "mcgd" (mixed coordinate gradient descent, adapted to large dimensions) or "alt" (alternating minimization, adapted to small dimensions)}

\item{thresh}{[positive number] convergence tolerance of algorithm, by default \code{1e-6}.}

\item{maxit}{[integer] maximum allowed number of iterations.}

\item{trace.it}{[boolean] whether convergence information should be printed}
}
\value{
\item{mi.imputed}{a list of length M containing the imputed count tables}
\item{mi.alpha}{a (Mxn) matrix containing in rows the estimated row effects (one row corresponds to one single imputation)}
\item{mi.beta}{a (Mxp) matrix containing in rows the estimated column effects (one row corresponds to one single imputation)}
\item{mi.epsilon}{a (Mxq) matrix containing in rows the estimated effects of covariates (one row corresponds to one single imputation)}
\item{mi.theta}{a list of length M containing the estimated interaction matrices}
\item{mi.mu}{a list of length M containing the estimated Poisson means}
\item{mi.y}{list of bootstrapped count tables used fot multiple imputation}
\item{Y}{original incomplete count table}
}
\description{
The mi.lori performs M multiple imputations using the
lori method. Multiple imputation allows to produce estimates of missing
values, as well as intervals of variability. The classical
procedure is to perform M multiple imputations using the mi.lori
method, and to aggregate them using the pool.lori method.
}
\examples{
X <- matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- mi.lori(Y, X, 10, 10, 2)
}
