% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/findModules.r
\name{findModules}
\alias{findModules}
\title{Find modules}
\usage{
findModules(M, iter = 50, sparse = TRUE, ...)
}
\arguments{
\item{M}{An adjacency matrix}

\item{iter}{Number of optimization runs to do}

\item{sparse}{Whether the matrix should be made sparse}

\item{...}{Other arguments}
}
\description{
This function takes a matrix, and performs a search for the best
partition in modules.
}
\examples{
M <- matrix(rbinom(100, 1, 0.3), ncol=10)
M <- M[rowSums(M)>0, colSums(M)>0]
mod <- findModules(M, iter=2, sparse=FALSE)
}

