% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpcde_fns.R
\name{lpcde_fn}
\alias{lpcde_fn}
\title{lpcde_fn: Conditional density estimator.}
\usage{
lpcde_fn(
  y_data,
  x_data,
  y_grid,
  x,
  p,
  q,
  p_RBC,
  q_RBC,
  bw,
  mu,
  nu,
  kernel_type,
  rbc = FALSE
)
}
\arguments{
\item{y_data}{Response variable dataset, vector.}

\item{x_data}{Covariate dataset, vector or matrix.}

\item{y_grid}{Numeric vector, specifies the grid of evaluation points along y-direction.}

\item{x}{Numeric vector or matrix, specifies the grid of evaluation points along x-direction.}

\item{p}{Polynomial order for y.}

\item{q}{Polynomial order for covariates.}

\item{p_RBC}{Nonnegative integer, specifies the order of the local polynomial for \code{Y} used to
construct bias-corrected point estimates. (Default is \code{p+1}.)}

\item{q_RBC}{Nonnegative integer, specifies the order of the local polynomial for \code{X} used to
construct bias-corrected point estimates. (Default is \code{q+1}.)}

\item{bw}{Numeric, bandwidth vector.}

\item{mu}{Degree of derivative with respect to y.}

\item{nu}{Degree of derivative with respect to x.}

\item{kernel_type}{Kernel function choice.}

\item{rbc}{Boolean for whether to return RBC estimate and standard errors.}
}
\value{
Conditional density estimate at all grid points.
}
\description{
Function for estimating the density function and its derivatives.
}
\keyword{internal}
