% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nslphom.R
\name{nslphom}
\alias{nslphom}
\title{Implements nslphom algorithm}
\usage{
nslphom(
  votes_election1,
  votes_election2,
  new_and_exit_voters = c("regular", "raw", "simultaneous", "full", "gold"),
  structural_zeros = NULL,
  iter.max = 10,
  min.first = FALSE,
  uniform = TRUE,
  distance.local = c("abs", "max", "none"),
  burnin = 0,
  verbose = FALSE,
  tol = 10^-5
)
}
\arguments{
\item{votes_election1}{data.frame (or matrix) of order IxJ (likely of final order IxJ-1
in \code{regular} and \code{raw} scenarios) with the votes gained by the \emph{J}
political options competing on election 1 (or origin) in the \emph{I}
territorial units considered.}

\item{votes_election2}{data.frame (or matrix) of order IxK (likely of final order IxK-1
in \code{regular} and \code{raw} scenarios) with the votes gained by
the \emph{K} political options competing on election 2 (or destination)
in the \emph{I} territorial units considered.}

\item{new_and_exit_voters}{A character string indicating the level of information available
regarding new entries and exits of the election censuses between the
two elections. This argument captures the different options discussed
on Section 3 of Romero et al. (2020). This argument admits five values:
\code{regular}, \code{raw}, \code{simultaneous}, \code{full} and \code{gold}. Default, \code{regular}.}

\item{structural_zeros}{Default, NULL. A list of vectors of length two, indicating the election options
for which no transfer of votes are allowed between election 1 and election 2.
For instance, when new_and_exit_voters is set to \code{"regular"},
lphom implicitly \verb{states structural_zeros = list(c(J, K))} in case exits and/or
entries are computed because the sum by rows of \code{votes_election1} and
\code{votes_election2} does not coincide.}

\item{iter.max}{Maximum number of iterations to be performed. The process ends when either the
number of iterations reaches iter.max or when the maximum variation between two consecutive
estimates of the probability transfer matrix is less than \code{tol}. By default, 10.}

\item{min.first}{A TRUE/FALSE value. If FALSE, the matrix associated with the minimum \code{HETe} after
performing \code{iter.max} iterations is taken as solution.
If TRUE, the associated matrix to the instant in which the first decrease of \code{HETe} occurs
is taken as solution. The process stops at that moment. In this last scenario
(when \code{min.first = TRUE}), \code{burnin = 0} is forced and \code{iter.max} is at least 100. Default, FALSE.}

\item{uniform}{A TRUE/FALSE value that indicates if census exits affects all the electoral options in a
(relatively) similar fashion in each voting unit: equation (13) of Pavia and Romero (2021).
Default, TRUE.}

\item{distance.local}{A string argument that indicates whether the second step of the lphom_local algorithm
should be performed in order to resolve potential indeterminacies of local solutions.
Default, \code{"abs"}.
If \code{distance.local = "abs"} lphom_local selects in its the second step the matrix
closer to the temporary global solution under L_1 norm, among the first step compatible matrices.
If \code{distance.local = "abs"} lphom_local selects in its the second step the matrix
closer to the temporary global solution under L_Inf norm, among the first step compatible matrices.
If \code{distance.local = "none"}, the second step of lphom_local is not performed.}

\item{burnin}{Number of initial solutions to be discarded before determining the final solution. By default, 0.}

\item{verbose}{A TRUE/FALSE value that indicates if the main outputs of the function should be
printed on the screen. Default, FALSE.}

\item{tol}{Maximum deviation allowed between two consecutive iterations. The process ends when the maximum
variation between two proportions for the estimation of the transfer matrix between two consecutive
iterations is less than \code{tol} or the maximum number of iterations has been reached. By default, 0.00001.}
}
\value{
A list with the following components
\item{VTM}{ A matrix of order JxK with the estimated percentages of vote transitions from election 1 to election 2.}
\item{OTM}{ A matrix of order KxJ with the estimated percentages of the origin of the votes obtained for the different options of election 2.}
\item{HETe}{ The estimated heterogeneity index as defined in equation (15) of Pavia and Romero (2021).}
\item{VTM.complete}{ A matrix of order J'xK' with the estimated proportions of vote transitions from election 1 to election 2, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
\item{VTM.sequence}{ Array of order J'xK'x(iter+1) (where \code{iter} is the efective number of iterations performed) of the estimated matrices corresponding to each iteration.}
\item{HETe.sequence}{ Numeric vector of length \code{iter+1} with the \code{HETe} coefficients corresponding to the matrices in \code{VTM.sequence}.}
\item{VTM_units}{ An array of order J'xK'xI with the estimated proportions of vote transitions from election 1 to election 2 attained for each unit in the selected iteration.}
\item{VTM_votes}{ An array of order J'xK'xI with the estimated matrix of vote transitions from election 1 to election 2 attained for for each unit in the selected iteration.}
\item{zeros}{ A list of vectors of length two, indicating the election options for which no transfer of votes are allowed between election 1 and election 2.}
\item{iter}{ The real final number of iterations performed before ending the process.}
\item{iter.min}{ Number of the iteration associated to the selected \code{VTM} solution.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
\item{origin}{ A matrix with the final data used as votes of the origin election after taking into account the level of information available regarding to new entries and exits of the election censuses between the two elections.}
\item{destination}{ A matrix with the final data used as votes of the origin election after taking into account the level of information available regarding to new entries and exits of the election censuses between the two elections.}
\item{EHet}{ A matrix of order IxK measuring in each spatial unit a distance to the homogeneity hypothesis, that is, the differences under the homogeneity hypothesis between the actual recorded results and the expected results with the solution in each territorial unit for each option of election two.}
\item{solution_init}{ A list with the main outputs produced by \strong{lphom()}.}
\itemize{
\item{\code{VTM_init}:}{ A matrix of order JxK with the estimated percentages of vote transitions from election 1 to election 2 initially obtained by \strong{lphom()}.}
\item{\code{OTM_init}:}{ A matrix of order KxJ with the estimated percentages of the origin of the votes obtained for the different options of election 2 initially obtained by \strong{lphom()}.}
\item{\code{HETe_init}:}{ The estimated heterogeneity index defined in equation (10) of Romero et al. (2020). }
\item{\code{EHet_init}:}{ A matrix of order IxK measuring in each spatial unit the distance to the homogeneity hypothesis, that is, the differences under the homogeneity hypothesis between the actual recorded results and the expected results, using the \strong{lphom()} solution, in each territorial unit for each option of election two.}
\item{\code{VTM.complete_init}:}{ A matrix of order J'xK' with the estimated proportions of vote transitions from election 1 to election 2 initially obtained by \strong{lphom()}, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
}
}
\description{
Estimates RxC vote transfer matrices (ecological contingency tables) with nslphom
}
\details{
Description of the \code{new_and_exit_voters} argument in more detail.
\itemize{
\item{\code{regular}: }{The default value. This argument accounts for the most plausible scenario.
A scenario with two elections elapsed at least some months.
In this scenario, (i) the column \emph{J} of  \code{votes_election1} corresponds to
new young electors who have the right to vote for the first time and (ii)
net exits (basically a consequence of mortality), and eventually net entries,
are computed according equation (7) of Romero et al. (2020), and (iii) we
assume net exits affect equally all the first \emph{J-1} options of election 1,
hence (8) and (9) constraints of Romero et al. (2020) are imposed.}
\item{\code{raw}: }{This value accounts for a scenario with two elections where only the raw
election data recorded in the \emph{I} territorial units, in which the area
under study is divided, are available. In this scenario, net exits
(basically deaths) and net entries (basically new young voters) are estimated
according to equation (7) of Romero et al. (2020). Constraints defined by
equations (8) and (9) of Romero et al. (2020) are imposed. In this scenario,
when net exits and/or net entries are negligible (such as between the first- and
second-round of French Presidential elections), they are omitted in the outputs.}
\item{\code{simultaneous}: }{This value accounts for either a scenario with two simultaneous elections
or a classical ecological inference problem. In this scenario, the sum by rows
of \code{votes_election1} and \code{votes_election2} must coincide. Constraints
defined by equations (8) and (9) of Romero et al. (2020) are not included
in the model.}
\item{\code{full}: }{This value accounts for a scenario with two elections elapsed at least some
months, where: (i) the column \emph{J-1} of votes_election1 totals new young
electors that have the right to vote for the first time; (ii) the column \emph{J}
of votes_election1 measures new immigrants that have the right to vote; and
(iii) the column \emph{K} of votes_election2 corresponds to total exits of the census
lists (due to death or emigration). In this scenario, the sum by rows of
\code{votes_election1} and \code{votes_election2} must agree and constraints (8)
and (9) of Romero et al. (2020) are imposed.}
\item{\code{gold}: }{This value accounts for a scenario similar to full, where total exits are
separated out between exits due to emigration (column \emph{K-1} of \code{votes_election2})
and death (column \emph{K} of \code{votes_election2}). In this scenario, the sum by rows
of \code{votes_election1} and \code{votes_election2} must agree. The same restrictions
as in the above scenario apply but for both columns \emph{K-1} and \emph{K} of the vote
transition probability matrix}
}
}
\examples{
mt.ns <- nslphom(France2017P[, 1:8] , France2017P[, 9:12],
                 new_and_exit_voters= "raw")
mt.ns$VTM
mt.ns$HETe
mt.ns$solution_init$HETe_init
}
\references{
Pavia, JM, and Romero, R (2021). Improving estimates accuracy of voter transitions. Two new algorithms for ecological inference based on linear programming, mimeo.
}
\seealso{
\code{\link{lphom}} \code{\link{tslphom}}

Other linear programing ecological inference functions: 
\code{\link{lphom}()},
\code{\link{tslphom}()}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Rafael Romero \email{rromero@eio.upv.es}
}
\concept{linear programing ecological inference functions}
