% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrpower}
\alias{lrpower}
\title{Log-rank test power}
\usage{
lrpower(
  kMax = NA_integer_,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  futilityBounds = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  numSubintervals = 300L
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates fixed prior to the trial.
Defaults to (1:kMax)/kMax if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., kMax-1. Defaults to
rep(-Inf, kMax-1) if left unspecified.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{Accrual time intervals, must start with 0, e.g.,
c(0, 3) breaks the time axis into 2 accrual intervals: [0, 3), [3, Inf).
Defaults to 0 for uniform accrual.}

\item{accrualIntensity}{A vector of accrual intensities, one for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution, must start with 0, e.g.,
c(0, 6) breaks the time axis into 2 event intervals: [0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event for the
active treatment group, one for each analysis time interval, by stratum.}

\item{lambda2}{A vector of hazard rates for the event for the
control group, one for each analysis time interval, by stratum.}

\item{gamma1}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout for the active treatment group.
Defaults to 0 for no dropout.}

\item{gamma2}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout for the control group.
Defaults to 0 for no dropout.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{First parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{Second parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{numSubintervals}{Number of sub-intervals to approximate the mean
and variance of the weighted log-rank score statistic.
Defaults to 300. Specify a larger number for better approximation.}
}
\value{
A list of the overall and stagewise rejection probabilities, the
futility stoppig probabilities, the overall and stagewise expected number
of events, number of patients, and analysis time, the input accrual and
follow-up durations, and whether a fixed follow-up is used.
}
\description{
Estimates the power, stopping probabilities, and expected
sample size in a two-group survival design.
}
\examples{
# Piecewise accrual time and intensity, piecewise exponential survivals,
# and 5\% dropout by the end of 1 year.

lrpower(kMax = 2, informationRates = c(0.8, 1),
        criticalValues = c(2.250, 2.025),
        allocationRatioPlanned = 1, accrualTime = seq(0, 9),
        accrualIntensity = c(26/9*seq(1, 9), 26),
        piecewiseSurvivalTime = c(0, 6),
        stratumFraction = c(0.2, 0.8),
        lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
        lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
        gamma1 = -log(1-0.05)/12,
        gamma2 = -log(1-0.05)/12, accrualDuration = 22,
        followupTime = 18, fixedFollowup = FALSE)

}
