% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{errorSpent}
\alias{errorSpent}
\title{Error spending functions}
\usage{
errorSpent(t, error, sf = "sfOF", sfpar = NA)
}
\arguments{
\item{t}{A vector of information fractions.}

\item{error}{Total error to spend.}

\item{sf}{Spending function. One of the following: "sfOF" for
O'Brien-Fleming type spending function, "sfP" for Pocock type spending
function, "sfKD" for Kim & DeMets spending function, and "sfHSD" for
Hwang, Shi & DeCani spending function. Defaults to "sfOF".}

\item{sfpar}{Parameter for the spending function. Corresponds to rho for
"sfKD" and gamma for "sfHSD".}
}
\value{
A vector of errors spent up to the interim look.
}
\description{
Obtains the error spent at the given information fractions
for the specified error spending function.
}
\examples{
errorSpent(t = 0.5, error = 0.025, sf = "sfOF")
errorSpent(t = c(0.5, 0.75, 1), error = 0.025, sf = "sfHSD", sfpar = -4)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
