% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getADRCI}
\alias{getADRCI}
\title{Repeated confidence interval after adaptation}
\usage{
getADRCI(
  L = NA_integer_,
  zL = NA_real_,
  IMax = NA_real_,
  kMax = NA_integer_,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.25,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  spendingTime = NA_real_,
  L2 = NA_integer_,
  zL2 = NA_real_,
  INew = NA_real_,
  MullerSchafer = 0L,
  informationRatesNew = NA_real_,
  efficacyStoppingNew = NA_integer_,
  typeAlphaSpendingNew = "sfOF",
  parameterAlphaSpendingNew = NA_real_,
  spendingTimeNew = NA_real_
)
}
\arguments{
\item{L}{The interim adaptation look of the primary trial.}

\item{zL}{The z-test statistic at the interim adaptation look of
the primary trial.}

\item{IMax}{The maximum information of the primary trial.}

\item{kMax}{The maximum number of stages of the primary trial.}

\item{informationRates}{The information rates of the primary trial.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is
allowed at each stage of the primary trial. Defaults to true
if left unspecified.}

\item{criticalValues}{The upper boundaries on the z-test statistic scale
for efficacy stopping for the primary trial.}

\item{alpha}{The significance level of the primary trial.
Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending for the primary trial.
One of the following:
"OF" for O'Brien-Fleming boundaries,
"P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries,
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and
"none" for no early efficacy stopping.
Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value of alpha spending
for the primary trial. Corresponds to Delta for "WT", rho for "sfKD",
and gamma for "sfHSD".}

\item{spendingTime}{The error spending time of the primary trial.
Defaults to missing, in which case, it is the same as
\code{informationRates}.}

\item{L2}{The look of interest in the secondary trial.}

\item{zL2}{The z-test statistic at the look of the secondary trial.}

\item{INew}{The maximum information of the secondary trial.}

\item{MullerSchafer}{Whether to use the Muller and Schafer (2001) method
for trial adaptation.}

\item{informationRatesNew}{The spacing of looks of the secondary trial.}

\item{efficacyStoppingNew}{The indicators of whether efficacy stopping is
allowed at each look of the secondary trial up to look \code{L2}.
Defaults to true if left unspecified.}

\item{typeAlphaSpendingNew}{The type of alpha spending for the secondary
trial. One of the following:
"OF" for O'Brien-Fleming boundaries,
"P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries,
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and
"none" for no early efficacy stopping.
Defaults to "sfOF".}

\item{parameterAlphaSpendingNew}{The parameter value of alpha spending
for the secondary trial. Corresponds to Delta for "WT",
rho for "sfKD", and gamma for "sfHSD".}

\item{spendingTimeNew}{The error spending time of the secondary trial.
up to look \code{L2}. Defaults to missing, in which case, it is
the same as \code{informationRatesNew}.}
}
\value{
A list with the following components:
\itemize{
\item \code{pvalue}: Repeated p-value for rejecting the null hypothesis.
\item \code{thetahat}: Point estimate of the parameter.
\item \code{cilevel}: Confidence interval level.
\item \code{lower}: Lower bound of repeated confidence interval.
\item \code{upper}: Upper bound of repeated confidence interval.
}
}
\description{
Obtains the repeated p-value, conservative point estimate,
and repeated confidence interval for an adaptive group sequential trial.
}
\examples{

# original group sequential design with 90\% power to detect delta = 6
delta = 6
sigma = 17
n = 282
(des1 = getDesign(IMax = n/(4*sigma^2), theta = delta, kMax = 3, 
                  alpha = 0.05, typeAlphaSpending = "sfHSD", 
                  parameterAlphaSpending = -4))

# interim look results
L = 1
n1 = n/3
delta1 = 4.5
sigma1 = 20
zL = delta1/sqrt(4/n1*sigma1^2)

t = des1$byStageResults$informationRates

# Muller & Schafer (2001) method to design the secondary trial: 
des2 = adaptDesign(
  betaNew = 0.2, L = L, zL = zL, theta = 5,
  kMax = 3, informationRates = t,
  alpha = 0.05, typeAlphaSpending = "sfHSD",
  parameterAlphaSpending = -4,
  MullerSchafer = TRUE,
  kNew = 3, typeAlphaSpendingNew = "sfHSD", 
  parameterAlphaSpendingNew = -2)

n2 = ceiling(des2$secondaryTrial$overallResults$maxInformation*4*20^2)
ns = round(n2*(1:3)/3)
(des2 = adaptDesign(
  INew = n2/(4*20^2), L = L, zL = zL, theta = 5,
  kMax = 3, informationRates = t,
  alpha = 0.05, typeAlphaSpending = "sfHSD",
  parameterAlphaSpending = -4,
  MullerSchafer = TRUE,
  kNew = 3, informationRatesNew = ns/n2,
  typeAlphaSpendingNew = "sfHSD",
  parameterAlphaSpendingNew = -2))

# termination at the second look of the secondary trial
L2 = 2
delta2 = 6.86
sigma2 = 21.77
zL2 = delta2/sqrt(4/197*sigma2^2)

t2 = des2$secondaryTrial$byStageResults$informationRates[1:L2]

# repeated confidence interval
getADRCI(L = L, zL = zL,
         IMax = n/(4*sigma1^2), kMax = 3,
         informationRates = t,
         alpha = 0.05, typeAlphaSpending = "sfHSD",
         parameterAlphaSpending = -4,
         L2 = L2, zL2 = zL2,
         INew = n2/(4*sigma2^2),
         MullerSchafer = TRUE,
         informationRatesNew = t2, 
         typeAlphaSpendingNew = "sfHSD",
         parameterAlphaSpendingNew = -2)

}
\references{
Cyrus R. Mehta, Peter Bauer, Martin Posch and Werner Brannath.
Repeated confidence intervals for adaptive group sequential trials.
Stat Med. 2007;26:5422–5433.
}
\seealso{
\code{\link{adaptDesign}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
